/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Expression;
import gnu.expr.Keyword;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.xml.MakeAttribute;
import gnu.kawa.xml.NodeConstructor;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.xml.NamespaceBinding;
import gnu.xml.XMLFilter;
import gnu.xml.XName;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.MethodHandle;

public class MakeElement
extends NodeConstructor
implements Externalizable {
    static final MethodHandle applyToConsumerME = Procedure.lookupApplyHandle(MakeElement.class, "applyToConsumerME");
    public static final MakeElement makeElementS = new MakeElement();
    public Symbol tag;
    private static final int HANDLING_KEYWORD_PARAMETERS = 4;
    NamespaceBinding namespaceNodes;
    static final ClassType typeMakeElement;
    static final Method startElementMethod3;
    static final Method startElementMethod4;
    static final Method endElementMethod;

    public MakeElement() {
        this.applyToConsumerMethod = applyToConsumerME;
        this.setCopyNamespacesMode(1);
    }

    public static MakeElement valueOf(Symbol tag, NamespaceBinding namespaceNodes, int options) {
        MakeElement m = new MakeElement();
        m.tag = tag;
        m.namespaceNodes = namespaceNodes;
        m.options = options;
        return m;
    }

    @Override
    public int numArgs() {
        return this.tag == null ? -4095 : -4096;
    }

    @Override
    public String toString() {
        return "makeElement[" + this.tag + "]";
    }

    public int getCopyNamespacesMode() {
        return this.options & 3;
    }

    public void setCopyNamespacesMode(int val) {
        this.options = val;
    }

    public boolean isHandlingKeywordParameters() {
        return (this.options & 4) != 0;
    }

    public void setHandlingKeywordParameters(boolean value) {
        this.options = value ? (this.options |= 4) : (this.options &= 0xFFFFFFFB);
    }

    public NamespaceBinding getNamespaceNodes() {
        return this.namespaceNodes;
    }

    public void setNamespaceNodes(NamespaceBinding bindings) {
        this.namespaceNodes = bindings;
    }

    public static Symbol getTagName(ApplyExp exp) {
        Object val;
        Expression arg0;
        Expression[] args = exp.getArgs();
        if (args.length > 0 && (arg0 = args[0]) instanceof QuoteExp && (val = ((QuoteExp)arg0).getValue()) instanceof Symbol) {
            return (Symbol)val;
        }
        return null;
    }

    public static void startElement(Consumer out, Symbol qname, int copyNamespacesMode, NamespaceBinding namespaceNodes) {
        XName type = new XName(qname, namespaceNodes);
        if (out instanceof XMLFilter) {
            ((XMLFilter)out).copyNamespacesMode = copyNamespacesMode;
        }
        out.startElement(type);
    }

    public static void startElement(Consumer out, Symbol qname, int copyNamespacesMode) {
        if (out instanceof XMLFilter) {
            ((XMLFilter)out).copyNamespacesMode = copyNamespacesMode;
        }
        out.startElement(qname);
    }

    public static void endElement(Consumer out, Object type) {
        out.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object applyToConsumerME(Procedure proc, CallContext ctx) throws Throwable {
        Consumer saved = ctx.consumer;
        MakeElement mk = (MakeElement)proc;
        Symbol tag = mk.tag;
        XMLFilter out = MakeElement.pushNodeContext(ctx);
        try {
            int i;
            Symbol type = tag != null ? tag : (Symbol)ctx.getNextArg();
            int n = i = tag != null ? 0 : 1;
            if (mk.namespaceNodes != null) {
                MakeElement.startElement(out, type, mk.options, mk.namespaceNodes);
            } else {
                MakeElement.startElement(out, type, mk.options);
            }
            int len = ctx.numArguments() - 1;
            while (i <= len) {
                Object arg = ctx.getArgAsObject(i);
                String key = ctx.getKeyword(i);
                if (key != null) {
                    MakeElement.writeContent(Keyword.make(key), out);
                }
                if (mk.getStringIsText()) {
                    MakeElement.writeContentS(arg, out);
                } else {
                    MakeElement.writeContent(arg, out);
                }
                if (mk.isHandlingKeywordParameters()) {
                    out.endAttribute();
                }
                ++i;
            }
            MakeElement.endElement(out, type);
        }
        finally {
            MakeElement.popNodeContext(saved, ctx);
        }
        return null;
    }

    @Override
    public void compileToNode(ApplyExp exp, Compilation comp, ConsumerTarget target) {
        int i;
        Variable consumer = target.getConsumerVariable();
        Expression[] args = exp.getArgs();
        int nargs = args.length;
        CodeAttr code = comp.getCode();
        code.emitLoad(consumer);
        code.emitDup();
        Target tagTarget = CheckedTarget.getInstance(Compilation.typeSymbol);
        if (this.tag == null) {
            args[0].compile(comp, tagTarget);
            i = 1;
        } else {
            comp.compileConstant(this.tag, tagTarget);
            i = 0;
        }
        code.emitDup(1, 1);
        code.emitPushInt(this.options);
        if (this.namespaceNodes != null) {
            comp.compileConstant(this.namespaceNodes, Target.pushObject);
            code.emitInvokeStatic(startElementMethod4);
        } else {
            code.emitInvokeStatic(startElementMethod3);
        }
        while (i < nargs) {
            MakeElement.compileChild(args[i], this.getStringIsText(), comp, target);
            if (this.isHandlingKeywordParameters()) {
                code.emitLoad(consumer);
                code.emitInvokeInterface(MakeAttribute.endAttributeMethod);
            }
            ++i;
        }
        code.emitInvokeStatic(endElementMethod);
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return Compilation.typeObject;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tag);
        out.writeObject(this.namespaceNodes);
        out.writeInt(this.options);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tag = (Symbol)in.readObject();
        this.namespaceNodes = (NamespaceBinding)in.readObject();
        this.options = in.readInt();
    }

    static {
        makeElementS.setStringIsText(true);
        typeMakeElement = ClassType.make("gnu.kawa.xml.MakeElement");
        startElementMethod3 = typeMakeElement.getDeclaredMethod("startElement", 3);
        startElementMethod4 = typeMakeElement.getDeclaredMethod("startElement", 4);
        endElementMethod = typeMakeElement.getDeclaredMethod("endElement", 2);
    }
}

