"use strict";

require("@testing-library/jest-dom/extend-expect");

var _react = require("@testing-library/react");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'random_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'random_html_id';
  }
})); //for mocking window.scroll(0,0)

const noop = () => {};

Object.defineProperty(window, 'scroll', {
  value: noop,
  writable: true
}); // for Plotly
//@ts-ignore

window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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