/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.PKCEProvider;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

public class DefaultPKCEProvider
implements PKCEProvider {
    private String codeVerifier = this.createCodeVerifier();
    private CodeChallenge codeChallenge = this.createCodeChallenge(this.codeVerifier);
    private static final int MAX_CODE_VERIFIER_LENGTH = 127;

    private String createCodeVerifier() {
        SecureRandom sr = new SecureRandom();
        byte[] code = new byte[127];
        sr.nextBytes(code);
        return Base64.getUrlEncoder().encodeToString(code);
    }

    private CodeChallenge createCodeChallenge(String codeVerifier) {
        return new CodeChallenge(codeVerifier);
    }

    @Override
    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    @Override
    public String getCodeChallenge() {
        return this.codeChallenge.getCodeChallenge();
    }

    @Override
    public String getCodeChallengeMethod() {
        return this.codeChallenge.getCodeChallengeMethod();
    }

    private class CodeChallenge {
        private String codeChallenge;
        private String codeChallengeMethod;

        CodeChallenge(String codeVerifier) {
            try {
                byte[] bytes = codeVerifier.getBytes();
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(bytes);
                byte[] digest = md.digest();
                this.codeChallenge = Base64.getUrlEncoder().encodeToString(digest);
                this.codeChallengeMethod = "S256";
            }
            catch (NoSuchAlgorithmException e) {
                this.codeChallenge = codeVerifier;
                this.codeChallengeMethod = "plain";
            }
        }

        public String getCodeChallenge() {
            return this.codeChallenge;
        }

        public String getCodeChallengeMethod() {
            return this.codeChallengeMethod;
        }
    }
}

