/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.util.resource.Resource;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public class ModernDefaultServlet
extends DefaultServlet {
    private Resource overrideResource;

    @Inject
    public ModernDefaultServlet(Config config) {
        String override = config.getString(Keys.WEB_OVERRIDE);
        if (override != null) {
            this.overrideResource = Resource.newResource((File)new File(override));
        }
    }

    public Resource getResource(String pathInContext) {
        if (this.overrideResource != null) {
            try {
                Resource override = this.overrideResource.addPath(pathInContext);
                if (override.exists()) {
                    return override;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.getResource(pathInContext.indexOf(46) < 0 ? "/" : pathInContext);
    }

    public String getWelcomeFile(String pathInContext) {
        return super.getWelcomeFile("/");
    }
}

