/* eslint-disable max-lines */

'use strict';

var _require = require('./core'),
    RequestBodySearch = _require.RequestBodySearch,
    Highlight = _require.Highlight,
    Script = _require.Script,
    GeoPoint = _require.GeoPoint,
    GeoShape = _require.GeoShape,
    IndexedShape = _require.IndexedShape,
    Sort = _require.Sort,
    Rescore = _require.Rescore,
    InnerHits = _require.InnerHits,
    SearchTemplate = _require.SearchTemplate,
    constructorWrapper = _require.util.constructorWrapper;

var _require2 = require('./queries'),
    MatchAllQuery = _require2.MatchAllQuery,
    MatchNoneQuery = _require2.MatchNoneQuery,
    _require2$fullTextQue = _require2.fullTextQueries,
    MatchQuery = _require2$fullTextQue.MatchQuery,
    MatchPhraseQuery = _require2$fullTextQue.MatchPhraseQuery,
    MatchPhrasePrefixQuery = _require2$fullTextQue.MatchPhrasePrefixQuery,
    MultiMatchQuery = _require2$fullTextQue.MultiMatchQuery,
    CommonTermsQuery = _require2$fullTextQue.CommonTermsQuery,
    QueryStringQuery = _require2$fullTextQue.QueryStringQuery,
    SimpleQueryStringQuery = _require2$fullTextQue.SimpleQueryStringQuery,
    _require2$termLevelQu = _require2.termLevelQueries,
    TermQuery = _require2$termLevelQu.TermQuery,
    TermsQuery = _require2$termLevelQu.TermsQuery,
    TermsSetQuery = _require2$termLevelQu.TermsSetQuery,
    RangeQuery = _require2$termLevelQu.RangeQuery,
    ExistsQuery = _require2$termLevelQu.ExistsQuery,
    PrefixQuery = _require2$termLevelQu.PrefixQuery,
    WildcardQuery = _require2$termLevelQu.WildcardQuery,
    RegexpQuery = _require2$termLevelQu.RegexpQuery,
    FuzzyQuery = _require2$termLevelQu.FuzzyQuery,
    TypeQuery = _require2$termLevelQu.TypeQuery,
    IdsQuery = _require2$termLevelQu.IdsQuery,
    _require2$compoundQue = _require2.compoundQueries,
    ConstantScoreQuery = _require2$compoundQue.ConstantScoreQuery,
    BoolQuery = _require2$compoundQue.BoolQuery,
    DisMaxQuery = _require2$compoundQue.DisMaxQuery,
    FunctionScoreQuery = _require2$compoundQue.FunctionScoreQuery,
    BoostingQuery = _require2$compoundQue.BoostingQuery,
    _require2$compoundQue2 = _require2$compoundQue.scoreFunctions,
    ScriptScoreFunction = _require2$compoundQue2.ScriptScoreFunction,
    WeightScoreFunction = _require2$compoundQue2.WeightScoreFunction,
    RandomScoreFunction = _require2$compoundQue2.RandomScoreFunction,
    FieldValueFactorFunction = _require2$compoundQue2.FieldValueFactorFunction,
    DecayScoreFunction = _require2$compoundQue2.DecayScoreFunction,
    _require2$joiningQuer = _require2.joiningQueries,
    NestedQuery = _require2$joiningQuer.NestedQuery,
    HasChildQuery = _require2$joiningQuer.HasChildQuery,
    HasParentQuery = _require2$joiningQuer.HasParentQuery,
    ParentIdQuery = _require2$joiningQuer.ParentIdQuery,
    _require2$geoQueries = _require2.geoQueries,
    GeoShapeQuery = _require2$geoQueries.GeoShapeQuery,
    GeoBoundingBoxQuery = _require2$geoQueries.GeoBoundingBoxQuery,
    GeoDistanceQuery = _require2$geoQueries.GeoDistanceQuery,
    GeoPolygonQuery = _require2$geoQueries.GeoPolygonQuery,
    _require2$specialized = _require2.specializedQueries,
    MoreLikeThisQuery = _require2$specialized.MoreLikeThisQuery,
    ScriptQuery = _require2$specialized.ScriptQuery,
    PercolateQuery = _require2$specialized.PercolateQuery,
    _require2$spanQueries = _require2.spanQueries,
    SpanTermQuery = _require2$spanQueries.SpanTermQuery,
    SpanMultiTermQuery = _require2$spanQueries.SpanMultiTermQuery,
    SpanFirstQuery = _require2$spanQueries.SpanFirstQuery,
    SpanNearQuery = _require2$spanQueries.SpanNearQuery,
    SpanOrQuery = _require2$spanQueries.SpanOrQuery,
    SpanNotQuery = _require2$spanQueries.SpanNotQuery,
    SpanContainingQuery = _require2$spanQueries.SpanContainingQuery,
    SpanWithinQuery = _require2$spanQueries.SpanWithinQuery,
    SpanFieldMaskingQuery = _require2$spanQueries.SpanFieldMaskingQuery;

var _require3 = require('./aggregations'),
    _require3$metricsAggr = _require3.metricsAggregations,
    AvgAggregation = _require3$metricsAggr.AvgAggregation,
    CardinalityAggregation = _require3$metricsAggr.CardinalityAggregation,
    ExtendedStatsAggregation = _require3$metricsAggr.ExtendedStatsAggregation,
    GeoBoundsAggregation = _require3$metricsAggr.GeoBoundsAggregation,
    GeoCentroidAggregation = _require3$metricsAggr.GeoCentroidAggregation,
    MaxAggregation = _require3$metricsAggr.MaxAggregation,
    MinAggregation = _require3$metricsAggr.MinAggregation,
    PercentilesAggregation = _require3$metricsAggr.PercentilesAggregation,
    PercentileRanksAggregation = _require3$metricsAggr.PercentileRanksAggregation,
    ScriptedMetricAggregation = _require3$metricsAggr.ScriptedMetricAggregation,
    StatsAggregation = _require3$metricsAggr.StatsAggregation,
    SumAggregation = _require3$metricsAggr.SumAggregation,
    TopHitsAggregation = _require3$metricsAggr.TopHitsAggregation,
    ValueCountAggregation = _require3$metricsAggr.ValueCountAggregation,
    _require3$bucketAggre = _require3.bucketAggregations,
    AdjacencyMatrixAggregation = _require3$bucketAggre.AdjacencyMatrixAggregation,
    ChildrenAggregation = _require3$bucketAggre.ChildrenAggregation,
    CompositeAggregation = _require3$bucketAggre.CompositeAggregation,
    DateHistogramAggregation = _require3$bucketAggre.DateHistogramAggregation,
    AutoDateHistogramAggregation = _require3$bucketAggre.AutoDateHistogramAggregation,
    DateRangeAggregation = _require3$bucketAggre.DateRangeAggregation,
    DiversifiedSamplerAggregation = _require3$bucketAggre.DiversifiedSamplerAggregation,
    FilterAggregation = _require3$bucketAggre.FilterAggregation,
    FiltersAggregation = _require3$bucketAggre.FiltersAggregation,
    GeoDistanceAggregation = _require3$bucketAggre.GeoDistanceAggregation,
    GeoHashGridAggregation = _require3$bucketAggre.GeoHashGridAggregation,
    GlobalAggregation = _require3$bucketAggre.GlobalAggregation,
    HistogramAggregation = _require3$bucketAggre.HistogramAggregation,
    IpRangeAggregation = _require3$bucketAggre.IpRangeAggregation,
    MissingAggregation = _require3$bucketAggre.MissingAggregation,
    NestedAggregation = _require3$bucketAggre.NestedAggregation,
    RangeAggregation = _require3$bucketAggre.RangeAggregation,
    ReverseNestedAggregation = _require3$bucketAggre.ReverseNestedAggregation,
    SamplerAggregation = _require3$bucketAggre.SamplerAggregation,
    SignificantTermsAggregation = _require3$bucketAggre.SignificantTermsAggregation,
    SignificantTextAggregation = _require3$bucketAggre.SignificantTextAggregation,
    TermsAggregation = _require3$bucketAggre.TermsAggregation,
    _require3$pipelineAgg = _require3.pipelineAggregations,
    AvgBucketAggregation = _require3$pipelineAgg.AvgBucketAggregation,
    DerivativeAggregation = _require3$pipelineAgg.DerivativeAggregation,
    MaxBucketAggregation = _require3$pipelineAgg.MaxBucketAggregation,
    MinBucketAggregation = _require3$pipelineAgg.MinBucketAggregation,
    SumBucketAggregation = _require3$pipelineAgg.SumBucketAggregation,
    StatsBucketAggregation = _require3$pipelineAgg.StatsBucketAggregation,
    ExtendedStatsBucketAggregation = _require3$pipelineAgg.ExtendedStatsBucketAggregation,
    PercentilesBucketAggregation = _require3$pipelineAgg.PercentilesBucketAggregation,
    MovingAverageAggregation = _require3$pipelineAgg.MovingAverageAggregation,
    CumulativeSumAggregation = _require3$pipelineAgg.CumulativeSumAggregation,
    BucketScriptAggregation = _require3$pipelineAgg.BucketScriptAggregation,
    BucketSelectorAggregation = _require3$pipelineAgg.BucketSelectorAggregation,
    SerialDifferencingAggregation = _require3$pipelineAgg.SerialDifferencingAggregation,
    BucketSortAggregation = _require3$pipelineAgg.BucketSortAggregation,
    MatrixStatsAggregation = _require3.matrixAggregations.MatrixStatsAggregation;

var _require4 = require('./suggesters'),
    TermSuggester = _require4.TermSuggester,
    DirectGenerator = _require4.DirectGenerator,
    PhraseSuggester = _require4.PhraseSuggester,
    CompletionSuggester = _require4.CompletionSuggester;

var recipes = require('./recipes');

exports.RequestBodySearch = RequestBodySearch;
exports.requestBodySearch = constructorWrapper(RequestBodySearch);

/* ============ ============ ============ */
/* ============== Queries =============== */
/* ============ ============ ============ */
exports.MatchAllQuery = MatchAllQuery;
exports.matchAllQuery = constructorWrapper(MatchAllQuery);

exports.MatchNoneQuery = MatchNoneQuery;
exports.matchNoneQuery = constructorWrapper(MatchNoneQuery);

/* ============ ============ ============ */
/* ========== Full Text Queries ========= */
/* ============ ============ ============ */
exports.MatchQuery = MatchQuery;
exports.matchQuery = constructorWrapper(MatchQuery);

exports.MatchPhraseQuery = MatchPhraseQuery;
exports.matchPhraseQuery = constructorWrapper(MatchPhraseQuery);

exports.MatchPhrasePrefixQuery = MatchPhrasePrefixQuery;
exports.matchPhrasePrefixQuery = constructorWrapper(MatchPhrasePrefixQuery);

exports.MultiMatchQuery = MultiMatchQuery;
exports.multiMatchQuery = constructorWrapper(MultiMatchQuery);

exports.CommonTermsQuery = CommonTermsQuery;
exports.commonTermsQuery = constructorWrapper(CommonTermsQuery);

exports.QueryStringQuery = QueryStringQuery;
exports.queryStringQuery = constructorWrapper(QueryStringQuery);

exports.SimpleQueryStringQuery = SimpleQueryStringQuery;
exports.simpleQueryStringQuery = constructorWrapper(SimpleQueryStringQuery);

/* ============ ============ ============ */
/* ========= Term Level Queries ========= */
/* ============ ============ ============ */
exports.TermQuery = TermQuery;
exports.termQuery = constructorWrapper(TermQuery);

exports.TermsQuery = TermsQuery;
exports.termsQuery = constructorWrapper(TermsQuery);

exports.TermsSetQuery = TermsSetQuery;
exports.termsSetQuery = constructorWrapper(TermsSetQuery);

exports.RangeQuery = RangeQuery;
exports.rangeQuery = constructorWrapper(RangeQuery);

exports.ExistsQuery = ExistsQuery;
exports.existsQuery = constructorWrapper(ExistsQuery);

exports.PrefixQuery = PrefixQuery;
exports.prefixQuery = constructorWrapper(PrefixQuery);

exports.WildcardQuery = WildcardQuery;
exports.wildcardQuery = constructorWrapper(WildcardQuery);

exports.RegexpQuery = RegexpQuery;
exports.regexpQuery = constructorWrapper(RegexpQuery);

exports.FuzzyQuery = FuzzyQuery;
exports.fuzzyQuery = constructorWrapper(FuzzyQuery);

exports.TypeQuery = TypeQuery;
exports.typeQuery = constructorWrapper(TypeQuery);

exports.IdsQuery = IdsQuery;
exports.idsQuery = constructorWrapper(IdsQuery);

/* ============ ============ ============ */
/* ========== Compound Queries ========== */
/* ============ ============ ============ */
exports.ConstantScoreQuery = ConstantScoreQuery;
exports.constantScoreQuery = constructorWrapper(ConstantScoreQuery);

exports.BoolQuery = BoolQuery;
exports.boolQuery = constructorWrapper(BoolQuery);

exports.DisMaxQuery = DisMaxQuery;
exports.disMaxQuery = constructorWrapper(DisMaxQuery);

exports.FunctionScoreQuery = FunctionScoreQuery;
exports.functionScoreQuery = constructorWrapper(FunctionScoreQuery);

exports.BoostingQuery = BoostingQuery;
exports.boostingQuery = constructorWrapper(BoostingQuery);

/* ============ ============ ============ */
/* =========== Joining Queries ========== */
/* ============ ============ ============ */
exports.NestedQuery = NestedQuery;
exports.nestedQuery = constructorWrapper(NestedQuery);

exports.HasChildQuery = HasChildQuery;
exports.hasChildQuery = constructorWrapper(HasChildQuery);

exports.HasParentQuery = HasParentQuery;
exports.hasParentQuery = constructorWrapper(HasParentQuery);

exports.ParentIdQuery = ParentIdQuery;
exports.parentIdQuery = constructorWrapper(ParentIdQuery);

/* ============ ============ ============ */
/* ============ Geo Queries ============= */
/* ============ ============ ============ */
exports.GeoShapeQuery = GeoShapeQuery;
exports.geoShapeQuery = constructorWrapper(GeoShapeQuery);

exports.GeoBoundingBoxQuery = GeoBoundingBoxQuery;
exports.geoBoundingBoxQuery = constructorWrapper(GeoBoundingBoxQuery);

exports.GeoDistanceQuery = GeoDistanceQuery;
exports.geoDistanceQuery = constructorWrapper(GeoDistanceQuery);

exports.GeoPolygonQuery = GeoPolygonQuery;
exports.geoPolygonQuery = constructorWrapper(GeoPolygonQuery);

/* ============ ============ ============ */
/* ======== Specialized Queries ========= */
/* ============ ============ ============ */
exports.MoreLikeThisQuery = MoreLikeThisQuery;
exports.moreLikeThisQuery = constructorWrapper(MoreLikeThisQuery);

exports.ScriptQuery = ScriptQuery;
exports.scriptQuery = constructorWrapper(ScriptQuery);

exports.PercolateQuery = PercolateQuery;
exports.percolateQuery = constructorWrapper(PercolateQuery);

/* ============ ============ ============ */
/* ============ Span Queries ============ */
/* ============ ============ ============ */
exports.SpanTermQuery = SpanTermQuery;
exports.spanTermQuery = constructorWrapper(SpanTermQuery);

exports.SpanMultiTermQuery = SpanMultiTermQuery;
exports.spanMultiTermQuery = constructorWrapper(SpanMultiTermQuery);

exports.SpanFirstQuery = SpanFirstQuery;
exports.spanFirstQuery = constructorWrapper(SpanFirstQuery);

exports.SpanNearQuery = SpanNearQuery;
exports.spanNearQuery = constructorWrapper(SpanNearQuery);

exports.SpanOrQuery = SpanOrQuery;
exports.spanOrQuery = constructorWrapper(SpanOrQuery);

exports.SpanNotQuery = SpanNotQuery;
exports.spanNotQuery = constructorWrapper(SpanNotQuery);

exports.SpanContainingQuery = SpanContainingQuery;
exports.spanContainingQuery = constructorWrapper(SpanContainingQuery);

exports.SpanWithinQuery = SpanWithinQuery;
exports.spanWithinQuery = constructorWrapper(SpanWithinQuery);

exports.SpanFieldMaskingQuery = SpanFieldMaskingQuery;
exports.spanFieldMaskingQuery = constructorWrapper(SpanFieldMaskingQuery);
/* ============ ============ ============ */
/* ======== Metrics Aggregations ======== */
/* ============ ============ ============ */
exports.AvgAggregation = AvgAggregation;
exports.avgAggregation = constructorWrapper(AvgAggregation);

exports.CardinalityAggregation = CardinalityAggregation;
exports.cardinalityAggregation = constructorWrapper(CardinalityAggregation);

exports.ExtendedStatsAggregation = ExtendedStatsAggregation;
exports.extendedStatsAggregation = constructorWrapper(ExtendedStatsAggregation);

exports.GeoBoundsAggregation = GeoBoundsAggregation;
exports.geoBoundsAggregation = constructorWrapper(GeoBoundsAggregation);

exports.GeoCentroidAggregation = GeoCentroidAggregation;
exports.geoCentroidAggregation = constructorWrapper(GeoCentroidAggregation);

exports.MaxAggregation = MaxAggregation;
exports.maxAggregation = constructorWrapper(MaxAggregation);

exports.MinAggregation = MinAggregation;
exports.minAggregation = constructorWrapper(MinAggregation);

exports.PercentilesAggregation = PercentilesAggregation;
exports.percentilesAggregation = constructorWrapper(PercentilesAggregation);

exports.PercentileRanksAggregation = PercentileRanksAggregation;
exports.percentileRanksAggregation = constructorWrapper(PercentileRanksAggregation);

exports.ScriptedMetricAggregation = ScriptedMetricAggregation;
exports.scriptedMetricAggregation = constructorWrapper(ScriptedMetricAggregation);

exports.StatsAggregation = StatsAggregation;
exports.statsAggregation = constructorWrapper(StatsAggregation);

exports.SumAggregation = SumAggregation;
exports.sumAggregation = constructorWrapper(SumAggregation);

exports.TopHitsAggregation = TopHitsAggregation;
exports.topHitsAggregation = constructorWrapper(TopHitsAggregation);

exports.ValueCountAggregation = ValueCountAggregation;
exports.valueCountAggregation = constructorWrapper(ValueCountAggregation);

/* ============ ============ ============ */
/* ========= Bucket Aggregations ======== */
/* ============ ============ ============ */
exports.AdjacencyMatrixAggregation = AdjacencyMatrixAggregation;
exports.adjacencyMatrixAggregation = constructorWrapper(AdjacencyMatrixAggregation);

exports.ChildrenAggregation = ChildrenAggregation;
exports.childrenAggregation = constructorWrapper(ChildrenAggregation);

exports.CompositeAggregation = CompositeAggregation;
exports.compositeAggregation = constructorWrapper(CompositeAggregation);

exports.DateHistogramAggregation = DateHistogramAggregation;
exports.dateHistogramAggregation = constructorWrapper(DateHistogramAggregation);

exports.AutoDateHistogramAggregation = AutoDateHistogramAggregation;
exports.autoDateHistogramAggregation = constructorWrapper(AutoDateHistogramAggregation);

exports.DateRangeAggregation = DateRangeAggregation;
exports.dateRangeAggregation = constructorWrapper(DateRangeAggregation);

exports.DiversifiedSamplerAggregation = DiversifiedSamplerAggregation;
exports.diversifiedSamplerAggregation = constructorWrapper(DiversifiedSamplerAggregation);

exports.FilterAggregation = FilterAggregation;
exports.filterAggregation = constructorWrapper(FilterAggregation);

exports.FiltersAggregation = FiltersAggregation;
exports.filtersAggregation = constructorWrapper(FiltersAggregation);

exports.GeoDistanceAggregation = GeoDistanceAggregation;
exports.geoDistanceAggregation = constructorWrapper(GeoDistanceAggregation);

exports.GeoHashGridAggregation = GeoHashGridAggregation;
exports.geoHashGridAggregation = constructorWrapper(GeoHashGridAggregation);

exports.GlobalAggregation = GlobalAggregation;
exports.globalAggregation = constructorWrapper(GlobalAggregation);

exports.HistogramAggregation = HistogramAggregation;
exports.histogramAggregation = constructorWrapper(HistogramAggregation);

exports.IpRangeAggregation = IpRangeAggregation;
exports.ipRangeAggregation = constructorWrapper(IpRangeAggregation);

exports.MissingAggregation = MissingAggregation;
exports.missingAggregation = constructorWrapper(MissingAggregation);

exports.NestedAggregation = NestedAggregation;
exports.nestedAggregation = constructorWrapper(NestedAggregation);

exports.RangeAggregation = RangeAggregation;
exports.rangeAggregation = constructorWrapper(RangeAggregation);

exports.ReverseNestedAggregation = ReverseNestedAggregation;
exports.reverseNestedAggregation = constructorWrapper(ReverseNestedAggregation);

exports.SamplerAggregation = SamplerAggregation;
exports.samplerAggregation = constructorWrapper(SamplerAggregation);

exports.SignificantTermsAggregation = SignificantTermsAggregation;
exports.significantTermsAggregation = constructorWrapper(SignificantTermsAggregation);

exports.SignificantTextAggregation = SignificantTextAggregation;
exports.significantTextAggregation = constructorWrapper(SignificantTextAggregation);

exports.TermsAggregation = TermsAggregation;
exports.termsAggregation = constructorWrapper(TermsAggregation);

/* ============ ============ ============ */
/* ======== Pipeline Aggregations ======= */
/* ============ ============ ============ */
exports.AvgBucketAggregation = AvgBucketAggregation;
exports.avgBucketAggregation = constructorWrapper(AvgBucketAggregation);

exports.DerivativeAggregation = DerivativeAggregation;
exports.derivativeAggregation = constructorWrapper(DerivativeAggregation);

exports.MaxBucketAggregation = MaxBucketAggregation;
exports.maxBucketAggregation = constructorWrapper(MaxBucketAggregation);

exports.MinBucketAggregation = MinBucketAggregation;
exports.minBucketAggregation = constructorWrapper(MinBucketAggregation);

exports.BucketSortAggregation = BucketSortAggregation;
exports.bucketSortAggregation = constructorWrapper(BucketSortAggregation);

exports.SumBucketAggregation = SumBucketAggregation;
exports.sumBucketAggregation = constructorWrapper(SumBucketAggregation);

exports.StatsBucketAggregation = StatsBucketAggregation;
exports.statsBucketAggregation = constructorWrapper(StatsBucketAggregation);

exports.ExtendedStatsBucketAggregation = ExtendedStatsBucketAggregation;
exports.extendedStatsBucketAggregation = constructorWrapper(ExtendedStatsBucketAggregation);

exports.PercentilesBucketAggregation = PercentilesBucketAggregation;
exports.percentilesBucketAggregation = constructorWrapper(PercentilesBucketAggregation);

exports.MovingAverageAggregation = MovingAverageAggregation;
exports.movingAverageAggregation = constructorWrapper(MovingAverageAggregation);

exports.CumulativeSumAggregation = CumulativeSumAggregation;
exports.cumulativeSumAggregation = constructorWrapper(CumulativeSumAggregation);

exports.BucketScriptAggregation = BucketScriptAggregation;
exports.bucketScriptAggregation = constructorWrapper(BucketScriptAggregation);

exports.BucketSelectorAggregation = BucketSelectorAggregation;
exports.bucketSelectorAggregation = constructorWrapper(BucketSelectorAggregation);

exports.SerialDifferencingAggregation = SerialDifferencingAggregation;
exports.serialDifferencingAggregation = constructorWrapper(SerialDifferencingAggregation);

/* ============ ============ ============ */
/* ========= Matrix Aggregations ======== */
/* ============ ============ ============ */
exports.MatrixStatsAggregation = MatrixStatsAggregation;
exports.matrixStatsAggregation = constructorWrapper(MatrixStatsAggregation);

/* ============ ============ ============ */
/* ========== Score Functions =========== */
/* ============ ============ ============ */
exports.ScriptScoreFunction = ScriptScoreFunction;
exports.scriptScoreFunction = constructorWrapper(ScriptScoreFunction);

exports.WeightScoreFunction = WeightScoreFunction;
exports.weightScoreFunction = constructorWrapper(WeightScoreFunction);

exports.RandomScoreFunction = RandomScoreFunction;
exports.randomScoreFunction = constructorWrapper(RandomScoreFunction);

exports.FieldValueFactorFunction = FieldValueFactorFunction;
exports.fieldValueFactorFunction = constructorWrapper(FieldValueFactorFunction);

exports.DecayScoreFunction = DecayScoreFunction;
exports.decayScoreFunction = constructorWrapper(DecayScoreFunction);

/* ============ ============ ============ */
/* ============= Suggesters ============= */
/* ============ ============ ============ */

exports.TermSuggester = TermSuggester;
exports.termSuggester = constructorWrapper(TermSuggester);

exports.DirectGenerator = DirectGenerator;
exports.directGenerator = constructorWrapper(DirectGenerator);

exports.PhraseSuggester = PhraseSuggester;
exports.phraseSuggester = constructorWrapper(PhraseSuggester);

exports.CompletionSuggester = CompletionSuggester;
exports.completionSuggester = constructorWrapper(CompletionSuggester);

/* ============ ============ ============ */
/* ============== Recipes =============== */
/* ============ ============ ============ */

/**
 * Helper recipes for common query use cases.
 *
 * If you have any recipes, please do share or better yet, create a [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/).
 *
 * Recipes:
 * - [`missingQuery`](/#missingquery)
 * - [`randomSortQuery`](/#randomsortquery)
 * - [`filterQuery`](/#filterquery)
 *
 * These can be accessed under the `recipes` namespace or
 * using the `cook[Recipe Name]` alias for ease of use.
 *
 * @example
 * // `recipes` namespace
 * const qry = esb.recipes.missingQuery('user');
 *
 * @example
 * // `cookMissingQuery` alias
 * const qry = esb.cookMissingQuery('user');
 */
exports.recipes = recipes;
exports.cookMissingQuery = recipes.missingQuery;
exports.cookRandomSortQuery = recipes.randomSortQuery;
exports.cookFilterQuery = recipes.filterQuery;

/* ============ ============ ============ */
/* ============ Miscellaneous =========== */
/* ============ ============ ============ */
exports.Highlight = Highlight;
exports.highlight = constructorWrapper(Highlight);

exports.Script = Script;
exports.script = constructorWrapper(Script);

exports.GeoPoint = GeoPoint;
exports.geoPoint = constructorWrapper(GeoPoint);

exports.GeoShape = GeoShape;
exports.geoShape = constructorWrapper(GeoShape);

exports.IndexedShape = IndexedShape;
exports.indexedShape = constructorWrapper(IndexedShape);

exports.Sort = Sort;
exports.sort = constructorWrapper(Sort);

exports.Rescore = Rescore;
exports.rescore = constructorWrapper(Rescore);

exports.InnerHits = InnerHits;
exports.innerHits = constructorWrapper(InnerHits);

exports.SearchTemplate = SearchTemplate;
exports.searchTemplate = constructorWrapper(SearchTemplate);

exports.prettyPrint = function prettyPrint(obj) {
    console.log(JSON.stringify(obj, null, 2));
};

/* eslint-enable */