"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlightsSavedObjects = void 0;

var _i18n = require("@osd/i18n");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const layerList = config => [{
  name: 'Default map',
  description: '',
  type: 'opensearch_vector_tile_map',
  id: '15bc3560-700e-479d-b49b-be5ece0451ce',
  zoomRange: [0, 22],
  opacity: 100,
  visibility: 'visible',
  source: {
    dataURL: config.opensearchVectorTileDataUrl
  },
  style: {
    styleURL: config.opensearchVectorTileStyleUrl
  }
}, {
  name: 'Flights On Time',
  description: 'Shows flights that are on time',
  type: 'documents',
  id: '033e870c-4195-48ce-8cc1-e428f0545ce4',
  zoomRange: [0, 6],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'FlightNum', 'Carrier', 'FlightTimeMin'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          FlightDelay: false
        }
      },
      $state: {
        store: 'appState'
      }
    }, {
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          Cancelled: false
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#36f20b',
    borderColor: '#36f20b',
    borderThickness: 1,
    markerSize: 5
  }
}, {
  name: 'Delayed Flights',
  description: 'Shows flights that are having delay',
  type: 'documents',
  id: '7ccae1a8-770d-4565-8c91-6125764fd344',
  zoomRange: [3, 6],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'Carrier', 'FlightDelayMin', 'FlightDelayType'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          FlightDelay: true
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#DA8B45',
    borderColor: '#DA8B45',
    borderThickness: 1,
    markerSize: 5
  }
}, {
  name: 'Cancelled Flights',
  description: 'Shows flights that are cancelled',
  type: 'documents',
  id: '70a61cb4-bea5-4a7b-8f2b-e6debd4334dd',
  zoomRange: [4, 22],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'FlightNum', 'Carrier'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          Cancelled: true
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#f40a0a',
    borderColor: '#f40a0a',
    borderThickness: 1,
    markerSize: 5
  }
}];

const getFlightsSavedObjects = config => {
  return [{
    id: '88a24e6c-0216-4f76-8bc7-c8db6c8705da',
    type: 'map',
    updated_at: '2023-02-20T03:57:15.482Z',
    version: 'WzIzLDFd',
    migrationVersion: {},
    attributes: {
      title: _i18n.i18n.translate('home.sampleData.flightsSpec.flightsStatusDestinationLocationMaps', {
        defaultMessage: '[Flights] Flights Status on Maps Destination Location'
      }),
      description: 'Sample map that shows flights at destination location that are on time, delayed and cancelled within a given time range.',
      layerList: JSON.stringify(layerList(config)),
      mapState: '{"timeRange":{"from":"now-1w","to":"now"},"query":{"query":"","language":"kuery"},"refreshInterval":{"pause":true,"value":12000}}'
    },
    references: []
  }];
};

exports.getFlightsSavedObjects = getFlightsSavedObjects;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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