/*
 * Decompiled with CFR 0.152.
 */
package com.babbel.mobile.android.commons.okhttpawssigner.internal;

import com.babbel.mobile.android.commons.okhttpawssigner.internal.HashingKt;
import com.babbel.mobile.android.commons.okhttpawssigner.internal.RequestExtensionsKt;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a,\u0010\u0005\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\rH\u0002\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\u001c\u0010\u0011\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a$\u0010\u0013\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a4\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u0003*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\u001c\u0010\u0018\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"SIGNING_ALGORITHM", "", "amazonDateHeader", "Lokhttp3/Request;", "amazonDateHeaderShort", "awsAuthorizationHeader", "accesKeyId", "accessKey", "region", "service", "bodyAsString", "bodyDigest", "canonicalHeaders", "Lokhttp3/Headers;", "canonicalQueryString", "canonicalRequest", "canonicalUri", "credentialScope", "rfc3986Encode", "signature", "signed", "kotlin.jvm.PlatformType", "accessKeyId", "signedHeaders", "stringToSign", "trimAll", "trimmedAndJoined", "", "okhttp-aws-signer"})
public final class RequestExtensionsKt {
    @NotNull
    public static final String SIGNING_ALGORITHM = "AWS4-HMAC-SHA256";

    public static final Request signed(@NotNull Request $this$signed, @NotNull String accessKeyId, @NotNull String accessKey, @NotNull String region, @NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)$this$signed, (String)"$this$signed");
        Intrinsics.checkNotNullParameter((Object)accessKeyId, (String)"accessKeyId");
        Intrinsics.checkNotNullParameter((Object)accessKey, (String)"accessKey");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return $this$signed.newBuilder().header("Authorization", RequestExtensionsKt.awsAuthorizationHeader($this$signed, accessKeyId, accessKey, region, service)).build();
    }

    @NotNull
    public static final String awsAuthorizationHeader(@NotNull Request $this$awsAuthorizationHeader, @NotNull String accesKeyId, @NotNull String accessKey, @NotNull String region, @NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)$this$awsAuthorizationHeader, (String)"$this$awsAuthorizationHeader");
        Intrinsics.checkNotNullParameter((Object)accesKeyId, (String)"accesKeyId");
        Intrinsics.checkNotNullParameter((Object)accessKey, (String)"accessKey");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return "AWS4-HMAC-SHA256 Credential=" + accesKeyId + '/' + RequestExtensionsKt.credentialScope($this$awsAuthorizationHeader, region, service) + ", SignedHeaders=" + RequestExtensionsKt.signedHeaders($this$awsAuthorizationHeader) + ", Signature=" + RequestExtensionsKt.signature($this$awsAuthorizationHeader, accessKey, region, service);
    }

    @NotNull
    public static final String signature(@NotNull Request $this$signature, @NotNull String accessKey, @NotNull String region, @NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)$this$signature, (String)"$this$signature");
        Intrinsics.checkNotNullParameter((Object)accessKey, (String)"accessKey");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return HashingKt.toHexString(HashingKt.hmacSha256(HashingKt.hmacSha256(HashingKt.hmacSha256(HashingKt.hmacSha256(HashingKt.hmacSha256("AWS4" + accessKey, RequestExtensionsKt.amazonDateHeaderShort($this$signature)), region), service), "aws4_request"), RequestExtensionsKt.stringToSign($this$signature, region, service)));
    }

    @NotNull
    public static final String stringToSign(@NotNull Request $this$stringToSign, @NotNull String region, @NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)$this$stringToSign, (String)"$this$stringToSign");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return StringsKt.trimMargin((String)("\n    |AWS4-HMAC-SHA256\n    |" + RequestExtensionsKt.amazonDateHeader($this$stringToSign) + "\n    |" + RequestExtensionsKt.credentialScope($this$stringToSign, region, service) + "\n    |" + HashingKt.hash(RequestExtensionsKt.canonicalRequest($this$stringToSign)) + "\n    "), (String)"|");
    }

    @NotNull
    public static final String canonicalRequest(@NotNull Request $this$canonicalRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$canonicalRequest, (String)"$this$canonicalRequest");
        return StringsKt.trimMargin((String)("\n    |" + $this$canonicalRequest.method() + "\n    |" + RequestExtensionsKt.canonicalUri($this$canonicalRequest) + "\n    |" + RequestExtensionsKt.canonicalQueryString($this$canonicalRequest) + "\n    |" + RequestExtensionsKt.canonicalHeaders($this$canonicalRequest) + "\n    |\n    |" + RequestExtensionsKt.signedHeaders($this$canonicalRequest) + "\n    |" + RequestExtensionsKt.bodyDigest($this$canonicalRequest) + "\n    "), (String)"|");
    }

    private static final String canonicalUri(Request $this$canonicalUri) {
        String string = $this$canonicalUri.url().encodedPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url().encodedPath()");
        CharSequence charSequence = string;
        Regex regex = new Regex("/+");
        String string2 = "/";
        boolean bl = false;
        return regex.replace(charSequence, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final String canonicalQueryString(Request $this$canonicalQueryString) {
        Object object;
        block5: {
            block4: {
                void $this$flatMapTo$iv$iv;
                Set set = $this$canonicalQueryString.url().queryParameterNames();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"url().queryParameterNames()");
                List list = CollectionsKt.sorted((Iterable)set);
                boolean bl = false;
                boolean bl2 = false;
                List it = list;
                boolean bl3 = false;
                Collection collection = it;
                boolean bl4 = false;
                object = !collection.isEmpty() ? list : null;
                if (object == null) break block4;
                Iterable $this$flatMap$iv = (Iterable)object;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    String name = (String)element$iv$iv;
                    boolean bl5 = false;
                    List list2 = $this$canonicalQueryString.url().queryParameterValues(name);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"url().queryParameterValues(name)");
                    Iterable iterable2 = CollectionsKt.sorted((Iterable)list2);
                    boolean $i$f$map = false;
                    void var12_14 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void value;
                        String string = (String)item$iv$iv;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl6 = false;
                        String string2 = name;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                        String string3 = RequestExtensionsKt.rfc3986Encode(string2);
                        void v5 = value;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"value");
                        Pair pair = new Pair((Object)string3, (Object)RequestExtensionsKt.rfc3986Encode((String)v5));
                        collection2.add(pair);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, (Function1)canonicalQueryString.3.INSTANCE, (int)30, null);
                if (object != null) break block5;
            }
            object = "";
        }
        return object;
    }

    private static final String canonicalHeaders(Request $this$canonicalHeaders) {
        Headers headers = $this$canonicalHeaders.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"headers()");
        return RequestExtensionsKt.canonicalHeaders(headers);
    }

    /*
     * WARNING - void declaration
     */
    private static final String signedHeaders(Request $this$signedHeaders) {
        void $this$mapTo$iv$iv;
        Set set = $this$signedHeaders.headers().names();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"headers().names()");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            Locale locale;
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            String string3 = v1;
            boolean bl2 = false;
            void v2 = string3;
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v2))).toString();
            Intrinsics.checkNotNullExpressionValue((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
            boolean bl3 = false;
            String string4 = string3;
            boolean bl4 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string5.toLowerCase(locale), (String)"(this as java.lang.String).toLowerCase(locale)");
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String bodyDigest(Request $this$bodyDigest) {
        String string = HashingKt.hash(RequestExtensionsKt.bodyAsString($this$bodyDigest));
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        return string4;
    }

    private static final String amazonDateHeader(Request $this$amazonDateHeader) {
        String string = $this$amazonDateHeader.header("x-amz-date");
        if (string == null) {
            throw (Throwable)new NoSuchFieldException("Request cannot be signed without having the x-amz-date header");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header(\"x-amz-date\")\n   \u2026g the x-amz-date header\")");
        return string;
    }

    private static final String amazonDateHeaderShort(Request $this$amazonDateHeaderShort) {
        int n;
        String string = $this$amazonDateHeaderShort.header("x-amz-date");
        if (string == null || (string = StringsKt.substring((String)string, (IntRange)new IntRange(n = 0, 7))) == null) {
            throw (Throwable)new NoSuchFieldException("Request cannot be signed without having the x-amz-date header");
        }
        return string;
    }

    private static final String bodyAsString(Request $this$bodyAsString) {
        Object object;
        block3: {
            block2: {
                object = $this$bodyAsString.body();
                if (object == null) break block2;
                RequestBody requestBody = object;
                boolean bl = false;
                boolean bl2 = false;
                RequestBody it = requestBody;
                boolean bl3 = false;
                Buffer buffer = new Buffer();
                RequestBody requestBody2 = $this$bodyAsString.newBuilder().build().body();
                Intrinsics.checkNotNull((Object)requestBody2);
                requestBody2.writeTo((BufferedSink)buffer);
                object = buffer.readUtf8();
                if (object != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private static final String canonicalHeaders(Headers $this$canonicalHeaders) {
        Set set = $this$canonicalHeaders.names();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"names()");
        return CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>($this$canonicalHeaders){
            final /* synthetic */ Headers $this_canonicalHeaders;

            @NotNull
            public final CharSequence invoke(String it) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                String string2 = string;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                boolean bl = false;
                String string3 = string2;
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                StringBuilder stringBuilder2 = stringBuilder.append(string5).append(':');
                List list = this.$this_canonicalHeaders.values(it);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values(it)");
                return stringBuilder2.append(RequestExtensionsKt.access$trimmedAndJoined(list)).toString();
            }
            {
                this.$this_canonicalHeaders = headers;
                super(1);
            }
        }), (int)30, null);
    }

    private static final String trimAll(String $this$trimAll) {
        CharSequence charSequence = $this$trimAll;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Regex regex = new Regex("\\s+");
        String string2 = " ";
        boolean bl2 = false;
        return regex.replace(charSequence, string2);
    }

    private static final String trimmedAndJoined(List<String> $this$trimmedAndJoined) {
        return CollectionsKt.joinToString$default((Iterable)$this$trimmedAndJoined, (CharSequence)",", null, null, (int)0, null, (Function1)trimmedAndJoined.1.INSTANCE, (int)30, null);
    }

    private static final String rfc3986Encode(String $this$rfc3986Encode) {
        String string = URLEncoder.encode($this$rfc3986Encode, "utf8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(this, \"utf8\")");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null), (String)"*", (String)"%2A", (boolean)false, (int)4, null), (String)"%7E", (String)"~", (boolean)false, (int)4, null);
    }

    private static final String credentialScope(Request $this$credentialScope, String region, String service) {
        return RequestExtensionsKt.amazonDateHeaderShort($this$credentialScope) + '/' + region + '/' + service + "/aws4_request";
    }

    public static final /* synthetic */ String access$trimmedAndJoined(List $this$access_u24trimmedAndJoined) {
        return RequestExtensionsKt.trimmedAndJoined($this$access_u24trimmedAndJoined);
    }

    public static final /* synthetic */ String access$trimAll(String $this$access_u24trimAll) {
        return RequestExtensionsKt.trimAll($this$access_u24trimAll);
    }
}

