/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.util;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.constant.CommonName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;

public class DiscoveryNodeFilterer {
    private static final Logger LOG = LogManager.getLogger(DiscoveryNodeFilterer.class);
    private final ClusterService clusterService;
    private final HotDataNodePredicate eligibleNodeFilter;

    public DiscoveryNodeFilterer(ClusterService clusterService) {
        this.clusterService = clusterService;
        this.eligibleNodeFilter = new HotDataNodePredicate();
    }

    public DiscoveryNode[] getEligibleDataNodes() {
        ClusterState state = this.clusterService.state();
        ArrayList<DiscoveryNode> eligibleNodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : state.nodes()) {
            if (!this.eligibleNodeFilter.test(node)) continue;
            eligibleNodes.add(node);
        }
        return eligibleNodes.toArray(new DiscoveryNode[0]);
    }

    public DiscoveryNode[] getAllNodes() {
        ClusterState state = this.clusterService.state();
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : state.nodes()) {
            nodes.add(node);
        }
        return nodes.toArray(new DiscoveryNode[0]);
    }

    public boolean isEligibleDataNode(DiscoveryNode node) {
        return this.eligibleNodeFilter.test(node);
    }

    public int getNumberOfEligibleDataNodes() {
        return this.getEligibleDataNodes().length;
    }

    public boolean isEligibleNode(DiscoveryNode node) {
        return this.eligibleNodeFilter.test(node);
    }

    static class HotDataNodePredicate
    implements Predicate<DiscoveryNode> {
        HotDataNodePredicate() {
        }

        @Override
        public boolean test(DiscoveryNode discoveryNode) {
            return discoveryNode.isDataNode() && discoveryNode.getAttributes().getOrDefault("box_type", CommonName.HOT_BOX_TYPE).equals(CommonName.HOT_BOX_TYPE);
        }
    }
}

