/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification;

import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.util.Map;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputFactory;
import org.tribuo.classification.ImmutableLabelInfo;
import org.tribuo.classification.Label;
import org.tribuo.classification.MutableLabelInfo;
import org.tribuo.classification.evaluation.LabelEvaluation;
import org.tribuo.classification.evaluation.LabelEvaluator;
import org.tribuo.evaluation.Evaluator;
import org.tribuo.provenance.OutputFactoryProvenance;

public final class LabelFactory
implements OutputFactory<Label> {
    private static final long serialVersionUID = 1L;
    public static final Label UNKNOWN_LABEL = new Label("LABEL##UNKNOWN");
    private static final OutputFactoryProvenance provenance = new LabelFactoryProvenance();
    private static final LabelEvaluator evaluator = new LabelEvaluator();

    public <V> Label generateOutput(V label) {
        return new Label(label.toString());
    }

    public Label getUnknownOutput() {
        return UNKNOWN_LABEL;
    }

    public MutableOutputInfo<Label> generateInfo() {
        return new MutableLabelInfo();
    }

    public ImmutableOutputInfo<Label> constructInfoForExternalModel(Map<Label, Integer> mapping) {
        OutputFactory.validateMapping(mapping);
        MutableLabelInfo info = new MutableLabelInfo();
        for (Map.Entry<Label, Integer> e : mapping.entrySet()) {
            info.observe(e.getKey());
        }
        return new ImmutableLabelInfo(info, mapping);
    }

    public Evaluator<Label, LabelEvaluation> getEvaluator() {
        return evaluator;
    }

    public int hashCode() {
        return "LabelFactory".hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof LabelFactory;
    }

    public OutputFactoryProvenance getProvenance() {
        return provenance;
    }

    public static final class LabelFactoryProvenance
    implements OutputFactoryProvenance {
        private static final long serialVersionUID = 1L;

        LabelFactoryProvenance() {
        }

        public LabelFactoryProvenance(Map<String, Provenance> map) {
        }

        public String getClassName() {
            return LabelFactory.class.getName();
        }

        public String toString() {
            return this.generateString("OutputFactory");
        }

        public boolean equals(Object other) {
            return other instanceof LabelFactoryProvenance;
        }

        public int hashCode() {
            return 31;
        }
    }
}

