/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.common.ValidationException;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.replication.action.index.ReplicateIndexRequest;
import org.opensearch.replication.util.ValidationUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 <2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003:\u0001<B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0004B)\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060+H\u0016\u00a2\u0006\u0002\u0010,J%\u0010*\u001a\u00020-2\u0016\u0010*\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060+\"\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000205H\u0016J\n\u00106\u001a\u0004\u0018\u000107H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012R\u001a\u0010\b\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR:\u0010 \u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010!j\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u0001`\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0015\"\u0004\b)\u0010\u0017\u00a8\u0006="}, d2={"Lorg/opensearch/replication/action/index/ReplicateIndexRequest;", "Lorg/opensearch/action/support/master/AcknowledgedRequest;", "Lorg/opensearch/action/IndicesRequest$Replaceable;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "()V", "followerIndex", "", "leaderAlias", "leaderIndex", "settings", "Lorg/opensearch/common/settings/Settings;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/common/settings/Settings;)V", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getFollowerIndex", "()Ljava/lang/String;", "setFollowerIndex", "(Ljava/lang/String;)V", "isAutoFollowRequest", "", "()Z", "setAutoFollowRequest", "(Z)V", "getLeaderAlias", "setLeaderAlias", "getLeaderIndex", "setLeaderIndex", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "setSettings", "(Lorg/opensearch/common/settings/Settings;)V", "useRoles", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getUseRoles", "()Ljava/util/HashMap;", "setUseRoles", "(Ljava/util/HashMap;)V", "waitForRestore", "getWaitForRestore", "setWaitForRestore", "indices", "", "()[Ljava/lang/String;", "Lorg/opensearch/action/IndicesRequest;", "([Ljava/lang/String;)Lorg/opensearch/action/IndicesRequest;", "indicesOptions", "Lorg/opensearch/action/support/IndicesOptions;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-cross-cluster-replication"})
public final class ReplicateIndexRequest
extends AcknowledgedRequest<ReplicateIndexRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public String followerIndex;
    public String leaderAlias;
    public String leaderIndex;
    @Nullable
    private HashMap<String, String> useRoles;
    private boolean waitForRestore;
    private boolean isAutoFollowRequest;
    @NotNull
    private Settings settings;
    @NotNull
    public static final String LEADER_CLUSTER_ROLE = "leader_cluster_role";
    @NotNull
    public static final String FOLLOWER_CLUSTER_ROLE = "follower_cluster_role";
    @NotNull
    private static final ObjectParser<ReplicateIndexRequest, Void> INDEX_REQ_PARSER = new ObjectParser("FollowIndexRequestParser", ReplicateIndexRequest::INDEX_REQ_PARSER$lambda$0);
    @NotNull
    private static final ObjectParser<HashMap<String, String>, Void> FGAC_ROLES_PARSER = new ObjectParser("UseRolesParser", ReplicateIndexRequest::FGAC_ROLES_PARSER$lambda$1);

    @NotNull
    public final String getFollowerIndex() {
        String string = this.followerIndex;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"followerIndex");
        return null;
    }

    public final void setFollowerIndex(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.followerIndex = string;
    }

    @NotNull
    public final String getLeaderAlias() {
        String string = this.leaderAlias;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"leaderAlias");
        return null;
    }

    public final void setLeaderAlias(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.leaderAlias = string;
    }

    @NotNull
    public final String getLeaderIndex() {
        String string = this.leaderIndex;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"leaderIndex");
        return null;
    }

    public final void setLeaderIndex(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.leaderIndex = string;
    }

    @Nullable
    public final HashMap<String, String> getUseRoles() {
        return this.useRoles;
    }

    public final void setUseRoles(@Nullable HashMap<String, String> hashMap) {
        this.useRoles = hashMap;
    }

    public final boolean getWaitForRestore() {
        return this.waitForRestore;
    }

    public final void setWaitForRestore(boolean bl) {
        this.waitForRestore = bl;
    }

    public final boolean isAutoFollowRequest() {
        return this.isAutoFollowRequest;
    }

    public final void setAutoFollowRequest(boolean bl) {
        this.isAutoFollowRequest = bl;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    public final void setSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.settings = settings;
    }

    private ReplicateIndexRequest() {
        Settings settings = Settings.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"EMPTY");
        this.settings = settings;
    }

    public ReplicateIndexRequest(@NotNull String followerIndex, @NotNull String leaderAlias, @NotNull String leaderIndex, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)followerIndex, (String)"followerIndex");
        Intrinsics.checkNotNullParameter((Object)leaderAlias, (String)"leaderAlias");
        Intrinsics.checkNotNullParameter((Object)leaderIndex, (String)"leaderIndex");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Settings settings2 = Settings.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)settings2, (String)"EMPTY");
        this.settings = settings2;
        this.setFollowerIndex(followerIndex);
        this.setLeaderAlias(leaderAlias);
        this.setLeaderIndex(leaderIndex);
        this.settings = settings;
    }

    public /* synthetic */ ReplicateIndexRequest(String string, String string2, String string3, Settings settings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Settings settings2 = Settings.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)settings2, (String)"EMPTY");
            settings = settings2;
        }
        this(string, string2, string3, settings);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException;
        block5: {
            block6: {
                validationException = new ActionRequestValidationException();
                if (this.leaderAlias == null || this.leaderIndex == null || this.followerIndex == null) {
                    validationException.addValidationError("Mandatory params are missing for the request");
                }
                ValidationUtil.INSTANCE.validateName(this.getLeaderIndex(), (ValidationException)validationException);
                ValidationUtil.INSTANCE.validateName(this.getFollowerIndex(), (ValidationException)validationException);
                if (this.useRoles == null) break block5;
                HashMap<String, String> hashMap = this.useRoles;
                Intrinsics.checkNotNull(hashMap);
                if (hashMap.size() < 2) break block6;
                HashMap<String, String> hashMap2 = this.useRoles;
                Intrinsics.checkNotNull(hashMap2);
                if (hashMap2.get(LEADER_CLUSTER_ROLE) == null) break block6;
                HashMap<String, String> hashMap3 = this.useRoles;
                Intrinsics.checkNotNull(hashMap3);
                if (hashMap3.get(FOLLOWER_CLUSTER_ROLE) != null) break block5;
            }
            validationException.addValidationError("Need roles for leader_cluster_role and follower_cluster_role");
        }
        if (validationException.validationErrors().isEmpty()) {
            return null;
        }
        return validationException;
    }

    @NotNull
    public IndicesRequest indices(String ... indices) {
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        return (IndicesRequest)this;
    }

    @NotNull
    public String[] indices() {
        String[] stringArray = new String[]{this.getFollowerIndex()};
        return stringArray;
    }

    @NotNull
    public IndicesOptions indicesOptions() {
        IndicesOptions indicesOptions = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        Intrinsics.checkNotNullExpressionValue((Object)indicesOptions, (String)"strictSingleIndexNoExpandForbidClosed()");
        return indicesOptions;
    }

    public ReplicateIndexRequest(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        Settings settings = Settings.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"EMPTY");
        this.settings = settings;
        String string = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inp.readString()");
        this.setLeaderAlias(string);
        String string2 = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inp.readString()");
        this.setLeaderIndex(string2);
        String string3 = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"inp.readString()");
        this.setFollowerIndex(string3);
        String leaderClusterRole = inp.readOptionalString();
        String followerClusterRole = inp.readOptionalString();
        this.useRoles = new HashMap();
        if (leaderClusterRole != null) {
            HashMap<String, String> hashMap = this.useRoles;
            Intrinsics.checkNotNull(hashMap);
            ((Map)hashMap).put(LEADER_CLUSTER_ROLE, leaderClusterRole);
        }
        if (followerClusterRole != null) {
            HashMap<String, String> hashMap = this.useRoles;
            Intrinsics.checkNotNull(hashMap);
            ((Map)hashMap).put(FOLLOWER_CLUSTER_ROLE, followerClusterRole);
        }
        this.waitForRestore = inp.readBoolean();
        this.isAutoFollowRequest = inp.readBoolean();
        Settings settings2 = Settings.readSettingsFromStream((StreamInput)inp);
        Intrinsics.checkNotNullExpressionValue((Object)settings2, (String)"readSettingsFromStream(inp)");
        this.settings = settings2;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeString(this.getLeaderAlias());
        out.writeString(this.getLeaderIndex());
        out.writeString(this.getFollowerIndex());
        HashMap<String, String> hashMap = this.useRoles;
        out.writeOptionalString(hashMap != null ? hashMap.get(LEADER_CLUSTER_ROLE) : null);
        HashMap<String, String> hashMap2 = this.useRoles;
        out.writeOptionalString(hashMap2 != null ? hashMap2.get(FOLLOWER_CLUSTER_ROLE) : null);
        out.writeBoolean(this.waitForRestore);
        out.writeBoolean(this.isAutoFollowRequest);
        Settings.writeSettingsToStream((Settings)this.settings, (StreamOutput)out);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) throws IOException {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        builder.field("leader_alias", this.getLeaderAlias());
        builder.field("leader_index", this.getLeaderIndex());
        builder.field("follower_index", this.getFollowerIndex());
        if (this.useRoles != null) {
            HashMap<String, String> hashMap = this.useRoles;
            Intrinsics.checkNotNull(hashMap);
            if (hashMap.size() == 2) {
                builder.field("use_roles");
                builder.startObject();
                HashMap<String, String> hashMap2 = this.useRoles;
                Intrinsics.checkNotNull(hashMap2);
                builder.field(LEADER_CLUSTER_ROLE, hashMap2.get(LEADER_CLUSTER_ROLE));
                HashMap<String, String> hashMap3 = this.useRoles;
                Intrinsics.checkNotNull(hashMap3);
                builder.field(FOLLOWER_CLUSTER_ROLE, hashMap3.get(FOLLOWER_CLUSTER_ROLE));
                builder.endObject();
            }
        }
        builder.field("wait_for_restore", this.waitForRestore);
        builder.field("is_autofollow_request", this.isAutoFollowRequest);
        builder.startObject("settings");
        this.settings.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static final ReplicateIndexRequest INDEX_REQ_PARSER$lambda$0() {
        return new ReplicateIndexRequest();
    }

    private static final HashMap FGAC_ROLES_PARSER$lambda$1() {
        return new HashMap();
    }

    private static final void _init_$lambda$2(HashMap useRoles, String role) {
        Intrinsics.checkNotNullParameter((Object)useRoles, (String)"useRoles");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        ((Map)useRoles).put(LEADER_CLUSTER_ROLE, role);
    }

    private static final void _init_$lambda$3(HashMap useRoles, String role) {
        Intrinsics.checkNotNullParameter((Object)useRoles, (String)"useRoles");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        ((Map)useRoles).put(FOLLOWER_CLUSTER_ROLE, role);
    }

    private static final void _init_$lambda$4(ReplicateIndexRequest reqParser, HashMap roles) {
        Intrinsics.checkNotNullParameter((Object)((Object)reqParser), (String)"reqParser");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        reqParser.useRoles = roles;
    }

    private static final void _init_$lambda$5(ReplicateIndexRequest request, Settings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        request.settings = settings;
    }

    private static final Settings _init_$lambda$6(XContentParser p, Void void_) {
        return Settings.fromXContent((XContentParser)p);
    }

    static {
        FGAC_ROLES_PARSER.declareStringOrNull(ReplicateIndexRequest::_init_$lambda$2, new ParseField(LEADER_CLUSTER_ROLE, new String[0]));
        FGAC_ROLES_PARSER.declareStringOrNull(ReplicateIndexRequest::_init_$lambda$3, new ParseField(FOLLOWER_CLUSTER_ROLE, new String[0]));
        INDEX_REQ_PARSER.declareString((arg_0, arg_1) -> ((KMutableProperty1)((KMutableProperty1)Companion.4.INSTANCE)).set(arg_0, arg_1), new ParseField("leader_alias", new String[0]));
        INDEX_REQ_PARSER.declareString((arg_0, arg_1) -> ((KMutableProperty1)((KMutableProperty1)Companion.6.INSTANCE)).set(arg_0, arg_1), new ParseField("leader_index", new String[0]));
        INDEX_REQ_PARSER.declareObjectOrDefault(ReplicateIndexRequest::_init_$lambda$4, (BiFunction)FGAC_ROLES_PARSER, null, new ParseField("use_roles", new String[0]));
        INDEX_REQ_PARSER.declareObjectOrDefault(ReplicateIndexRequest::_init_$lambda$5, ReplicateIndexRequest::_init_$lambda$6, null, new ParseField("settings", new String[0]));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006R9\u0010\u0003\u001a*\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0007\u0012\u0004\u0012\u00020\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/replication/action/index/ReplicateIndexRequest$Companion;", "", "()V", "FGAC_ROLES_PARSER", "Lorg/opensearch/core/xcontent/ObjectParser;", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "Ljava/lang/Void;", "getFGAC_ROLES_PARSER", "()Lorg/opensearch/core/xcontent/ObjectParser;", "FOLLOWER_CLUSTER_ROLE", "INDEX_REQ_PARSER", "Lorg/opensearch/replication/action/index/ReplicateIndexRequest;", "LEADER_CLUSTER_ROLE", "fromXContent", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "followerIndex", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectParser<HashMap<String, String>, Void> getFGAC_ROLES_PARSER() {
            return FGAC_ROLES_PARSER;
        }

        @NotNull
        public final ReplicateIndexRequest fromXContent(@NotNull XContentParser parser, @NotNull String followerIndex) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)followerIndex, (String)"followerIndex");
            ReplicateIndexRequest followIndexRequest = (ReplicateIndexRequest)((Object)INDEX_REQ_PARSER.parse(parser, null));
            followIndexRequest.setFollowerIndex(followerIndex);
            HashMap<String, String> hashMap = followIndexRequest.getUseRoles();
            boolean bl = hashMap != null ? hashMap.size() == 0 : false;
            if (bl) {
                followIndexRequest.setUseRoles(null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)((Object)followIndexRequest), (String)"followIndexRequest");
            return followIndexRequest;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

