/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.CodecService;
import org.opensearch.index.codec.customcodecs.ZstdCodec;
import org.opensearch.index.codec.customcodecs.ZstdNoDictCodec;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.mapper.MapperService;

public class CustomCodecService
extends CodecService {
    private final Map<String, Codec> codecs;
    public static final String ZSTD_CODEC = "zstd";
    public static final String ZSTD_NO_DICT_CODEC = "zstd_no_dict";

    public CustomCodecService(MapperService mapperService, IndexSettings indexSettings, Logger logger) {
        super(mapperService, indexSettings, logger);
        int compressionLevel = (Integer)indexSettings.getValue(EngineConfig.INDEX_CODEC_COMPRESSION_LEVEL_SETTING);
        MapBuilder codecs = MapBuilder.newMapBuilder();
        if (mapperService == null) {
            codecs.put((Object)ZSTD_CODEC, (Object)new ZstdCodec(compressionLevel));
            codecs.put((Object)ZSTD_NO_DICT_CODEC, (Object)new ZstdNoDictCodec(compressionLevel));
        } else {
            codecs.put((Object)ZSTD_CODEC, (Object)new ZstdCodec(mapperService, logger, compressionLevel));
            codecs.put((Object)ZSTD_NO_DICT_CODEC, (Object)new ZstdNoDictCodec(mapperService, logger, compressionLevel));
        }
        this.codecs = codecs.immutableMap();
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            return super.codec(name);
        }
        return codec;
    }

    public String[] availableCodecs() {
        return (String[])Stream.concat(Arrays.stream(super.availableCodecs()), this.codecs.keySet().stream()).toArray(String[]::new);
    }
}

