/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.correlation.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.Explicit;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.securityanalytics.correlation.index.CorrelationParamsContext;
import org.opensearch.securityanalytics.correlation.index.mapper.LuceneFieldMapper;

public abstract class CorrelationVectorFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "sa_vector";
    protected Explicit<Boolean> ignoreMalformed;
    protected boolean stored;
    protected boolean hasDocValues;
    protected Integer dimension;
    protected CorrelationParamsContext correlationParams;

    private static CorrelationVectorFieldMapper toType(FieldMapper in) {
        return (CorrelationVectorFieldMapper)in;
    }

    public CorrelationVectorFieldMapper(String simpleName, CorrelationVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.stored = stored;
        this.hasDocValues = hasDocValues;
        this.dimension = mappedFieldType.getDimension();
    }

    protected CorrelationVectorFieldMapper clone() {
        return (CorrelationVectorFieldMapper)super.clone();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext parseContext) throws IOException {
        this.parseCreateField(parseContext, this.fieldType().getDimension());
    }

    protected abstract void parseCreateField(ParseContext var1, int var2) throws IOException;

    Optional<float[]> getFloatsFromContext(ParseContext context, int dimension) throws IOException {
        float value;
        context.path().add(this.simpleName());
        ArrayList<Float> vector = new ArrayList<Float>();
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                value = context.parser().floatValue();
                if (Float.isNaN(value)) {
                    throw new IllegalArgumentException("Correlation vector values cannot be NaN");
                }
                if (Float.isInfinite(value)) {
                    throw new IllegalArgumentException("Correlation vector values cannot be infinity");
                }
                vector.add(Float.valueOf(value));
                token = context.parser().nextToken();
            }
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = context.parser().floatValue();
            if (Float.isNaN(value)) {
                throw new IllegalArgumentException("Correlation vector values cannot be NaN");
            }
            if (Float.isInfinite(value)) {
                throw new IllegalArgumentException("Correlation vector values cannot be infinity");
            }
            vector.add(Float.valueOf(value));
            context.parser().nextToken();
        } else if (token == XContentParser.Token.VALUE_NULL) {
            context.path().remove();
            return Optional.empty();
        }
        if (dimension != vector.size()) {
            String errorMessage = String.format("Vector dimension mismatch. Expected: %d, Given: %d", dimension, vector.size());
            throw new IllegalArgumentException(errorMessage);
        }
        float[] array = new float[vector.size()];
        int i = 0;
        for (Float f : vector) {
            array[i++] = f.floatValue();
        }
        return Optional.of(array);
    }

    protected boolean docValuesByDefault() {
        return true;
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init((FieldMapper)this);
    }

    public boolean parsesArrayValue() {
        return true;
    }

    public CorrelationVectorFieldType fieldType() {
        return (CorrelationVectorFieldType)super.fieldType();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Boolean)this.ignoreMalformed.value());
        }
    }

    public static class CorrelationVectorFieldType
    extends MappedFieldType {
        int dimension;
        CorrelationParamsContext correlationParams;

        public CorrelationVectorFieldType(String name, Map<String, String> meta, int dimension) {
            this(name, meta, dimension, null);
        }

        public CorrelationVectorFieldType(String name, Map<String, String> meta, int dimension, CorrelationParamsContext correlationParams) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
            this.dimension = dimension;
            this.correlationParams = correlationParams;
        }

        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String s) {
            throw new UnsupportedOperationException("Correlation Vector do not support fields search");
        }

        public String typeName() {
            return CorrelationVectorFieldMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            return new FieldExistsQuery(this.name());
        }

        public Query termQuery(Object o, QueryShardContext context) {
            throw new QueryShardException(context, String.format(Locale.getDefault(), "Correlation vector do not support exact searching, use Correlation queries instead: [%s]", this.name()), new Object[0]);
        }

        public int getDimension() {
            return this.dimension;
        }

        public CorrelationParamsContext getCorrelationParams() {
            return this.correlationParams;
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        protected Boolean ignoreMalformed;
        protected final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.boolParam((String)"store", (boolean)false, m -> CorrelationVectorFieldMapper.toType((FieldMapper)m).stored, (boolean)false);
        protected final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.boolParam((String)"doc_values", (boolean)false, m -> CorrelationVectorFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        protected final ParametrizedFieldMapper.Parameter<Integer> dimension = new ParametrizedFieldMapper.Parameter("dimension", false, () -> -1, (n, c, o) -> {
            int value;
            if (o == null) {
                throw new IllegalArgumentException("Dimension cannot be null");
            }
            try {
                value = XContentMapValues.nodeIntegerValue((Object)o);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format(Locale.getDefault(), "Unable to parse [dimension] from provided value [%s] for vector [%s]", o, this.name));
            }
            if (value <= 0) {
                throw new IllegalArgumentException(String.format(Locale.getDefault(), "Dimension value must be greater than 0 for vector: %s", this.name));
            }
            return value;
        }, m -> CorrelationVectorFieldMapper.toType((FieldMapper)m).dimension);
        protected final ParametrizedFieldMapper.Parameter<CorrelationParamsContext> correlationParamsContext = new ParametrizedFieldMapper.Parameter("correlation_ctx", false, () -> null, (n, c, o) -> CorrelationParamsContext.parse(o), m -> CorrelationVectorFieldMapper.toType((FieldMapper)m).correlationParams);
        protected final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.stored, this.hasDocValues, this.dimension, this.meta, this.correlationParamsContext);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit((Object)this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit((Object)((Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings())), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public ParametrizedFieldMapper build(Mapper.BuilderContext context) {
            CorrelationParamsContext correlationParams = (CorrelationParamsContext)this.correlationParamsContext.getValue();
            FieldMapper.MultiFields multiFieldsBuilder = this.multiFieldsBuilder.build((Mapper.Builder)this, context);
            FieldMapper.CopyTo copyToBuilder = this.copyTo.build();
            Explicit<Boolean> ignoreMalformed = this.ignoreMalformed(context);
            Map metaValue = (Map)this.meta.getValue();
            CorrelationVectorFieldType mappedFieldType = new CorrelationVectorFieldType(this.buildFullName(context), metaValue, (Integer)this.dimension.getValue(), correlationParams);
            LuceneFieldMapper.CreateLuceneFieldMapperInput createLuceneFieldMapperInput = new LuceneFieldMapper.CreateLuceneFieldMapperInput(this.name, mappedFieldType, multiFieldsBuilder, copyToBuilder, ignoreMalformed, (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), correlationParams);
            return new LuceneFieldMapper(createLuceneFieldMapperInput);
        }
    }

    public static class Names {
        public static final String IGNORE_MALFORMED = "ignore_malformed";
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit((Object)false, false);
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext context) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.parse(name, context, node);
            if ((Integer)builder.dimension.getValue() == -1) {
                throw new IllegalArgumentException(String.format(Locale.getDefault(), "Dimension value missing for vector: %s", name));
            }
            return builder;
        }
    }
}

