/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestClearScrollAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.DELETE, "/_search/scroll"), new RestHandler.Route(RestRequest.Method.DELETE, "/_search/scroll/{scroll_id}")));
    }

    @Override
    public String getName() {
        return "clear_scroll_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String scrollIds = request.param("scroll_id");
        ClearScrollRequest clearRequest = new ClearScrollRequest();
        clearRequest.setScrollIds(Arrays.asList(Strings.splitStringByCommaToArray((String)scrollIds)));
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)xContentParser -> {
            if (xContentParser != null) {
                try {
                    clearRequest.fromXContent((XContentParser)xContentParser);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse request body", e);
                }
            }
        }));
        return channel -> client.clearScroll(clearRequest, new RestStatusToXContentListener<ClearScrollResponse>((RestChannel)channel));
    }
}

