/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.regex;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.core.common.Strings;

public class Regex {
    public static final int UNICODE_CHARACTER_CLASS = 256;

    public static boolean isSimpleMatchPattern(String str) {
        return str.indexOf(42) != -1;
    }

    public static boolean isMatchAllPattern(String str) {
        return str.equals("*");
    }

    public static Automaton simpleMatchToAutomaton(String pattern) {
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        int previous = 0;
        int i = pattern.indexOf(42);
        while (i != -1) {
            automata.add(Automata.makeString((String)pattern.substring(previous, i)));
            automata.add(Automata.makeAnyString());
            previous = i + 1;
            i = pattern.indexOf(42, i + 1);
        }
        automata.add(Automata.makeString((String)pattern.substring(previous)));
        return Operations.concatenate(automata);
    }

    public static Automaton simpleMatchToAutomaton(String ... patterns) {
        if (patterns.length < 1) {
            throw new IllegalArgumentException("There must be at least one pattern, zero given");
        }
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        for (String pattern : patterns) {
            automata.add(Regex.simpleMatchToAutomaton(pattern));
        }
        return Operations.union(automata);
    }

    public static boolean simpleMatch(String pattern, String str) {
        return Regex.simpleMatch(pattern, str, false);
    }

    public static boolean simpleMatch(String pattern, String str, boolean caseInsensitive) {
        if (pattern == null || str == null) {
            return false;
        }
        if (caseInsensitive) {
            pattern = Strings.toLowercaseAscii((String)pattern);
            str = Strings.toLowercaseAscii((String)str);
        }
        return Regex.simpleMatchWithNormalizedStrings(pattern, str);
    }

    private static boolean simpleMatchWithNormalizedStrings(String pattern, String str) {
        int sIdx = 0;
        int pIdx = 0;
        int match = 0;
        int wildcardIdx = -1;
        while (sIdx < str.length()) {
            if (pIdx < pattern.length() && str.charAt(sIdx) == pattern.charAt(pIdx)) {
                ++sIdx;
                ++pIdx;
                continue;
            }
            if (pIdx < pattern.length() && pattern.charAt(pIdx) == '*') {
                wildcardIdx = pIdx++;
                match = sIdx;
                continue;
            }
            if (wildcardIdx != -1) {
                pIdx = wildcardIdx + 1;
                sIdx = ++match;
                continue;
            }
            return false;
        }
        while (pIdx < pattern.length() && pattern.charAt(pIdx) == '*') {
            ++pIdx;
        }
        return pIdx == pattern.length();
    }

    public static boolean simpleMatch(String[] patterns, String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!Regex.simpleMatch(pattern, str)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean simpleMatch(List<String> patterns, String str) {
        return patterns != null && Regex.simpleMatch(patterns.toArray(Strings.EMPTY_ARRAY), str);
    }

    public static boolean simpleMatch(String[] patterns, String[] types) {
        if (patterns != null && types != null) {
            for (String type : types) {
                for (String pattern : patterns) {
                    if (!Regex.simpleMatch(pattern, type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Pattern compile(String regex, String flags) {
        int pFlags = flags == null ? 0 : Regex.flagsFromString(flags);
        return Pattern.compile(regex, pFlags);
    }

    public static int flagsFromString(String flags) {
        int pFlags = 0;
        for (String s : Strings.delimitedListToStringArray((String)flags, (String)"|")) {
            if (s.isEmpty()) continue;
            if ("CASE_INSENSITIVE".equals(s = s.toUpperCase(Locale.ROOT))) {
                pFlags |= 2;
                continue;
            }
            if ("MULTILINE".equals(s)) {
                pFlags |= 8;
                continue;
            }
            if ("DOTALL".equals(s)) {
                pFlags |= 0x20;
                continue;
            }
            if ("UNICODE_CASE".equals(s)) {
                pFlags |= 0x40;
                continue;
            }
            if ("CANON_EQ".equals(s)) {
                pFlags |= 0x80;
                continue;
            }
            if ("UNIX_LINES".equals(s)) {
                pFlags |= 1;
                continue;
            }
            if ("LITERAL".equals(s)) {
                pFlags |= 0x10;
                continue;
            }
            if ("COMMENTS".equals(s)) {
                pFlags |= 4;
                continue;
            }
            if ("UNICODE_CHAR_CLASS".equals(s) || "UNICODE_CHARACTER_CLASS".equals(s)) {
                pFlags |= 0x100;
                continue;
            }
            throw new IllegalArgumentException("Unknown regex flag [" + s + "]");
        }
        return pFlags;
    }

    public static String flagsToString(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 2) != 0) {
            sb.append("CASE_INSENSITIVE|");
        }
        if ((flags & 8) != 0) {
            sb.append("MULTILINE|");
        }
        if ((flags & 0x20) != 0) {
            sb.append("DOTALL|");
        }
        if ((flags & 0x40) != 0) {
            sb.append("UNICODE_CASE|");
        }
        if ((flags & 0x80) != 0) {
            sb.append("CANON_EQ|");
        }
        if ((flags & 1) != 0) {
            sb.append("UNIX_LINES|");
        }
        if ((flags & 0x10) != 0) {
            sb.append("LITERAL|");
        }
        if ((flags & 4) != 0) {
            sb.append("COMMENTS|");
        }
        if ((flags & 0x100) != 0) {
            sb.append("UNICODE_CHAR_CLASS|");
        }
        return sb.toString();
    }
}

