/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.settings;

import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.settings.MLCommonsSettings;

public class MLFeatureEnabledSetting {
    private volatile Boolean isRemoteInferenceEnabled;
    private volatile Boolean isUpdateConnectorEnabled;

    public MLFeatureEnabledSetting(ClusterService clusterService, Settings settings) {
        this.isRemoteInferenceEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED.get(settings);
        this.isUpdateConnectorEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_UPDATE_CONNECTOR_ENABLED.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED, it -> {
            this.isRemoteInferenceEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_UPDATE_CONNECTOR_ENABLED, it -> {
            this.isUpdateConnectorEnabled = it;
        });
    }

    public boolean isRemoteInferenceEnabled() {
        return this.isRemoteInferenceEnabled;
    }

    public boolean isUpdateConnectorEnabled() {
        return this.isUpdateConnectorEnabled;
    }
}

