/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.sdbc.SQLException;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandMetaData;

public class CommandName {
    private CommandMetaData oCommandMetaData;
    private String CatalogName = PropertyNames.EMPTY_STRING;
    private String SchemaName = PropertyNames.EMPTY_STRING;
    private String TableName = PropertyNames.EMPTY_STRING;
    private String DisplayName = PropertyNames.EMPTY_STRING;
    private String ComposedName = PropertyNames.EMPTY_STRING;
    private String AliasName = PropertyNames.EMPTY_STRING;
    private boolean bCatalogAtStart;
    private String sCatalogSep;
    private boolean baddQuotation = true;

    public CommandName(CommandMetaData commandMetaData, String string) {
        this.oCommandMetaData = commandMetaData;
        this.setComposedCommandName(string);
    }

    public CommandName(CommandMetaData commandMetaData, String string, String string2, String string3, boolean bl) {
        try {
            this.baddQuotation = bl;
            this.oCommandMetaData = commandMetaData;
            if (string != null && this.oCommandMetaData.xDBMetaData.supportsCatalogsInTableDefinitions() && !string.equals(PropertyNames.EMPTY_STRING)) {
                this.CatalogName = string;
            }
            if (string2 != null && this.oCommandMetaData.xDBMetaData.supportsSchemasInTableDefinitions() && !string2.equals(PropertyNames.EMPTY_STRING)) {
                this.SchemaName = string2;
            }
            if (string3 != null && !string3.equals(PropertyNames.EMPTY_STRING)) {
                this.TableName = string3;
            }
            this.setComposedCommandName();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
        }
    }

    private void setComposedCommandName(String string) {
        try {
            int n;
            if (!this.setMetaDataAttributes()) {
                return;
            }
            this.DisplayName = string;
            if (this.oCommandMetaData.xDBMetaData.supportsCatalogsInDataManipulation() && (n = string.indexOf(this.sCatalogSep)) >= 0) {
                if (this.bCatalogAtStart) {
                    this.CatalogName = string.substring(0, n);
                    string = string.substring(n + 1, string.length());
                } else {
                    this.CatalogName = string.substring(n + 1, string.length());
                    string = string.substring(0, n);
                }
            }
            if (this.oCommandMetaData.xDBMetaData.supportsSchemasInDataManipulation()) {
                String[] stringArray = JavaTools.ArrayoutofString(string, ".");
                if (stringArray.length > 1) {
                    this.SchemaName = stringArray[0];
                    this.TableName = stringArray[1];
                } else {
                    this.TableName = string;
                }
            } else {
                this.TableName = string;
            }
            this.setComposedCommandName();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void setComposedCommandName() {
        if (this.setMetaDataAttributes()) {
            if (this.CatalogName != null && !this.CatalogName.equals(PropertyNames.EMPTY_STRING) && this.bCatalogAtStart) {
                this.ComposedName = this.quoteName(this.CatalogName) + this.sCatalogSep;
            }
            if (this.SchemaName != null && !this.SchemaName.equals(PropertyNames.EMPTY_STRING)) {
                this.ComposedName = this.ComposedName + this.quoteName(this.SchemaName) + ".";
            }
            this.ComposedName = this.ComposedName.equals(PropertyNames.EMPTY_STRING) ? this.quoteName(this.TableName) : this.ComposedName + this.quoteName(this.TableName);
            if (!this.bCatalogAtStart && this.CatalogName != null && !this.CatalogName.equals(PropertyNames.EMPTY_STRING)) {
                this.ComposedName = this.ComposedName + this.sCatalogSep + this.quoteName(this.CatalogName);
            }
        }
    }

    private boolean setMetaDataAttributes() {
        try {
            this.bCatalogAtStart = this.oCommandMetaData.xDBMetaData.isCatalogAtStart();
            this.sCatalogSep = this.oCommandMetaData.xDBMetaData.getCatalogSeparator();
            this.oCommandMetaData.xDBMetaData.getIdentifierQuoteString();
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            return false;
        }
    }

    private String quoteName(String string) {
        if (this.baddQuotation) {
            return CommandName.quoteName(string, this.oCommandMetaData.getIdentifierQuote());
        }
        return string;
    }

    public static String quoteName(String string, String string2) {
        if (string == null) {
            string = PropertyNames.EMPTY_STRING;
        }
        return string2 + string + string2;
    }

    public void setAliasName(String string) {
        this.AliasName = string;
    }

    public String getAliasName() {
        return this.AliasName;
    }

    public String getCatalogName() {
        return this.CatalogName;
    }

    public String getComposedName() {
        return this.ComposedName;
    }

    public String getDisplayName() {
        return this.DisplayName;
    }

    public String getSchemaName() {
        return this.SchemaName;
    }

    public String getTableName() {
        return this.TableName;
    }

    public CommandMetaData getCommandMetaData() {
        return this.oCommandMetaData;
    }
}

