/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource,
Monitor,
Diagnosable {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit = false;
    protected boolean savedXAConnectionAutoCommit = false;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMPROMOTE = 8;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection = null;
    protected OracleXAConnection xaconnection = null;
    protected int timeout = 60;
    protected String dblink = null;
    private Connection logicalConnection = null;
    private String synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
    private String synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
    private String recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected boolean canBeMigratablySuspended = false;
    private boolean isTMRScanStarted = false;
    private static final Xid[] NO_XID = new Xid[0];
    static final boolean jtaWLSEnabled = "true".equals(OracleXAResource.getSystemProperty("oracle.ucp.wls.jta", "false"));
    Xid lastActiveXid = null;
    protected Xid activeXid = null;
    protected Hashtable<Xid, XidListEntry> xidHash = new Hashtable(50);
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    public OracleXAResource() {
    }

    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        this.setConnection(pm_conn);
        this.xaconnection = xaconn;
    }

    public final void setConnection(Connection pm_conn) throws XAException {
        boolean isOracleConnection;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.connection = pm_conn;
            if (pm_conn == null) {
                throw (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
            }
        }
        boolean bl = isOracleConnection = pm_conn instanceof OracleConnection || pm_conn instanceof ReplayableConnection;
        if (!isOracleConnection) {
            throw new IllegalArgumentException("Connection is not an instance of OracleConnection");
        }
    }

    protected final OracleConnection getPhysicalConnection() throws XAException {
        try {
            if (this.connection instanceof ReplayableConnection) {
                ((ReplayableConnection)((Object)this.connection)).disableReplay();
                return (OracleConnection)((_Proxy_)((Object)this.connection))._getDelegate_();
            }
        }
        catch (SQLException sqle) {
            throw this.convertError(sqle, -3);
        }
        return (OracleConnection)this.connection;
    }

    final XidListEntry getMatchingXidListEntry(Xid xid) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            XidListEntry x;
            XidListEntry xidListEntry = x = this.xidHash.get(xid);
            return xidListEntry;
        }
    }

    protected final boolean removeXidFromList(Xid xid) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.isSameXid(this.activeXid, xid)) {
                this.activeXid = null;
            }
            boolean bl = this.xidHash.remove(xid) != null;
            return bl;
        }
    }

    final boolean isSameXid(Xid xid1, Xid xid2) {
        if (xid1 == null) {
            return xid1 == xid2;
        }
        return xid1.equals(xid2);
    }

    protected final boolean isOnStack(Xid xid) throws XAException {
        return this.xidHash.containsKey(xid);
    }

    protected final boolean isXidListEmpty() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.xidHash.isEmpty();
            return bl;
        }
    }

    protected void createOrUpdateXid(Xid xid, boolean isSuspended, boolean[] isLocallySuspended) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "createOrUpdateXid", "(xid = " + xid + ", isSuspended = " + isSuspended + " ): stacking xid", null, null);
            XidListEntry x = this.getMatchingXidListEntry(xid);
            if (x != null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "createOrUpdateXid", "(xid = " + xid + ", isSuspended = " + isSuspended + " ): x(not supposed to be null) = " + x, null, null);
                isLocallySuspended[0] = true;
                x.isSuspended = isSuspended;
            } else {
                x = new XidListEntry(xid, isSuspended);
                this.xidHash.put(xid, x);
            }
            if (isSuspended) {
                this.lastActiveXid = this.activeXid;
                this.activeXid = null;
            } else {
                this.enterGlobalTxnMode();
                if (this.lastActiveXid != null && this.isSameXid(xid, this.lastActiveXid)) {
                    this.lastActiveXid = null;
                }
                this.activeXid = x.xid;
            }
        }
    }

    protected boolean updateXidList(Xid xid, boolean[] flags) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "updateXidList", "(xid = " + xid + "): trying to clear stacked xid", null, null);
            boolean foundXid = false;
            XidListEntry x = this.getMatchingXidListEntry(xid);
            if (x != null) {
                foundXid = true;
                flags[0] = true;
                flags[1] = x.isSuspended;
                if (x.isSuspended) {
                    this.enterGlobalTxnMode();
                } else {
                    this.exitGlobalTxnMode();
                }
            }
            boolean bl = foundXid;
            return bl;
        }
    }

    protected boolean isXidSuspended(Xid xid) throws XAException {
        boolean returnValue = false;
        XidListEntry x = this.getMatchingXidListEntry(xid);
        if (x != null) {
            returnValue = x.isSuspended;
        }
        return returnValue;
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid stackedXid = null;
        if (this.activeXid != null && !this.isSameXid(this.activeXid, xid)) {
            stackedXid = this.activeXid;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "suspendStacked", "(xid = " + xid + "): Before calling end()", null, null);
            if (!this.isXidSuspended(this.activeXid)) {
                this.end(this.activeXid, 0x2000000);
                this.lastActiveXid = this.activeXid;
                this.activeXid = null;
            }
        }
        return stackedXid;
    }

    protected void resumeStacked(Xid xid) throws XAException {
        if (xid != null) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "resumeStacked", "(xid = " + xid + "): Before calling start()", null, null);
            this.start(xid, 0x8000000);
            this.activeXid = xid;
        }
    }

    @Override
    public abstract void start(Xid var1, int var2) throws XAException;

    @Override
    public abstract void end(Xid var1, int var2) throws XAException;

    @Override
    public abstract void commit(Xid var1, boolean var2) throws XAException;

    @Override
    public abstract int prepare(Xid var1) throws XAException;

    @Override
    public abstract void forget(Xid var1) throws XAException;

    @Override
    public abstract void rollback(Xid var1) throws XAException;

    @Override
    public Xid[] recover(int flag) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock lock = physicalConnection.acquireCloseableLock();){
            if ((flag & 0x1800000) != flag) {
                Throwable xae = DatabaseError.createXAException(-5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "recover", "(flag = " + flag + "): XAER_INVAL, invalid flag", null, xae);
                throw (XAException)xae;
            }
            if (flag == 0x1000000) {
                this.isTMRScanStarted = true;
            } else {
                if (this.isTMRScanStarted && flag == 0x800000) {
                    this.isTMRScanStarted = false;
                    Xid[] xae = NO_XID;
                    return xae;
                }
                if (this.isTMRScanStarted && flag == 0) {
                    Xid[] xae = NO_XID;
                    return xae;
                }
            }
            Statement stmt = null;
            ResultSet rset = null;
            ArrayList<OracleXid> xidCollection = new ArrayList<OracleXid>(50);
            try {
                stmt = physicalConnection.createStatement();
                try {
                    stmt.execute(this.synchronizeBeforeRecoverNewCall);
                }
                catch (Exception exc) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "recover", "(flag = " + flag + "): DBMS_XA.dist_txn_sync failed: " + exc, null, null);
                    stmt.execute(this.synchronizeBeforeRecoverOldCall);
                }
                rset = stmt.executeQuery(this.recoverySqlRows);
                while (rset.next()) {
                    xidCollection.add(new OracleXid(rset.getInt(1), rset.getBytes(2), rset.getBytes(3)));
                }
            }
            catch (SQLException sqe) {
                Throwable xae = DatabaseError.createXAException(-3).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "recover", "(flag = " + flag + "): SQLException(internal): " + sqe, null, xae);
                throw (XAException)xae;
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (rset != null) {
                        rset.close();
                    }
                }
                catch (Exception exception) {}
            }
            int xidSize = xidCollection.size();
            Xid[] xids = new Xid[xidSize];
            System.arraycopy(xidCollection.toArray(), 0, xids, 0, xidSize);
            Xid[] xidArray = xids;
            return xidArray;
        }
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
            }
            catch (SQLException ignoreException) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "restoreAutoCommitModeForGlobalTransaction", "got exception: " + ignoreException, null, null);
            }
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.savedConnectionAutoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
                this.xaconnection.setAutoCommit(false);
            }
            catch (SQLException ignoreException) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.OracleXAResource", "saveAndAlterAutoCommitModeForGlobalTransaction", "got exception: " + ignoreException, null, null);
            }
        }
    }

    public void resume(Xid xid) throws XAException {
        this.start(xid, 0x8000000);
    }

    public void join(Xid xid) throws XAException {
        this.start(xid, 0x200000);
    }

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000000);
    }

    public void join(Xid xid, int timeout) throws XAException {
        this.timeout = timeout;
        this.start(xid, 0x200000);
    }

    public void resume(Xid xid, int timeout) throws XAException {
        this.timeout = timeout;
        this.start(xid, 0x8000000);
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        Connection conn1 = null;
        if (!(xares instanceof OracleXAResource)) {
            return false;
        }
        conn1 = ((OracleXAResource)xares).getConnection();
        try {
            if (this.connection == null || ((OracleConnection)this.connection).isClosed()) {
                return false;
            }
            if (jtaWLSEnabled) {
                return this.connection == conn1;
            }
            String l_url = ((OracleConnection)this.connection).getURL();
            String l_prt = ((OracleConnection)this.connection).getProtocolType();
            if (conn1 != null) {
                boolean _returnVal = conn1.equals(this.connection) || ((OracleConnection)conn1).getURL().equals(l_url) || ((OracleConnection)conn1).getProtocolType().equals(l_prt) && l_prt.equals("kprb");
                return _returnVal;
            }
        }
        catch (SQLException sqe) {
            throw (XAException)DatabaseError.createXAException(-3).fillInStackTrace();
        }
        return false;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        this.timeout = seconds;
        return true;
    }

    public String getDBLink() {
        return this.dblink;
    }

    public void setDBLink(String dblink) {
        this.dblink = dblink;
    }

    public void setLogicalConnection(Connection conn) {
        this.logicalConnection = conn;
    }

    protected void allowGlobalTxnModeOnly(int errorCode) throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            throw (XAException)DatabaseError.createXAException(errorCode).fillInStackTrace();
        }
    }

    protected void exitGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(0);
    }

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(1);
    }

    protected void checkError(int error) throws XAException {
        if ((error & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), error).fillInStackTrace();
        }
    }

    protected void checkError(int error, SQLException sqlException) throws XAException {
        if ((error & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), error, sqlException).fillInStackTrace();
        }
    }

    protected void checkError(int error, int defaultXAError) throws XAException {
        if ((error & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), error, defaultXAError).fillInStackTrace();
        }
    }

    protected XAException convertError(SQLException sqlex, int defaultXAError) {
        return (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), sqlex, defaultXAError).fillInStackTrace();
    }

    private static String getSystemProperty(String str, String defaultValue) {
        if (str != null) {
            final String fstr = str;
            final String fdefaultValue = defaultValue;
            final String[] rets = new String[]{defaultValue};
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    rets[0] = System.getProperty(fstr, fdefaultValue);
                    return null;
                }
            });
            return rets[0].trim().toLowerCase();
        }
        return defaultValue;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.connection;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;

        XidListEntry(Xid x, boolean s) {
            this.xid = x;
            this.isSuspended = s;
        }
    }
}

