/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import oracle.sql.Datum;

class SINT32
extends Datum {
    boolean isBigEndian;

    private SINT32() {
    }

    private SINT32(byte[] bytes, boolean bigEndian) {
        this.setBytes(bytes);
        this.isBigEndian = bigEndian;
    }

    public boolean isConvertibleTo(Class c) {
        return false;
    }

    @Override
    public Object toJdbc() {
        return SINT32.bytesToInt(this.shareBytes(), this.isBigEndian);
    }

    @Override
    public Object makeJdbcArray(int count) {
        return new SINT32[count];
    }

    static SINT32[] createArray(int count) {
        return new SINT32[count];
    }

    static int bytesToInt(byte[] bytes, boolean isBigEndian) {
        int out = 0;
        int count = isBigEndian ? 0 : bytes.length - 1;
        for (byte b : bytes) {
            out |= (b & 0xFF) << count * 8;
            count += isBigEndian ? 1 : -1;
        }
        return out;
    }

    static SINT32 valueOf(int intValue, boolean isBigEndian) {
        byte[] bytes = new byte[4];
        int count = isBigEndian ? 0 : bytes.length - 1;
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)(intValue >> count * 8 & 0xFF);
            count += isBigEndian ? 1 : -1;
        }
        return new SINT32(bytes, isBigEndian);
    }
}

