/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.securityrequirement;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.securityrequirement.SecurityRequirementConstant;
import io.smallrye.openapi.runtime.util.Annotations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class SecurityRequirementReader {
    private SecurityRequirementReader() {
    }

    public static Optional<List<SecurityRequirement>> readSecurityRequirements(AnnotationValue securityRequirements, AnnotationValue securityRequirementsSets) {
        SecurityRequirement requirement;
        AnnotationInstance[] nestedArray;
        if (securityRequirements == null && securityRequirementsSets == null) {
            return Optional.empty();
        }
        ArrayList<SecurityRequirement> requirements = new ArrayList<SecurityRequirement>();
        if (securityRequirements != null) {
            IoLogging.logger.annotationsArray("@SecurityRequirement");
            for (AnnotationInstance requirementAnno : nestedArray = securityRequirements.asNestedArray()) {
                requirement = SecurityRequirementReader.readSecurityRequirement(requirementAnno);
                if (requirement == null) continue;
                requirements.add(requirement);
            }
        }
        if (securityRequirementsSets != null) {
            IoLogging.logger.annotationsArray("@SecurityRequirementsSet");
            for (AnnotationInstance requirementSetAnno : nestedArray = securityRequirementsSets.asNestedArray()) {
                requirement = SecurityRequirementReader.readSecurityRequirementsSet(requirementSetAnno);
                if (requirement == null) continue;
                requirements.add(requirement);
            }
        }
        return Optional.of(requirements);
    }

    public static Optional<List<SecurityRequirement>> readSecurityRequirements(JsonNode node) {
        if (node != null && node.isArray()) {
            IoLogging.logger.jsonArray("SecurityRequirement");
            ArrayList<SecurityRequirement> requirements = new ArrayList<SecurityRequirement>(node.size());
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode arrayItem : arrayNode) {
                requirements.add(SecurityRequirementReader.readSecurityRequirement(arrayItem));
            }
            return Optional.of(requirements);
        }
        return Optional.empty();
    }

    public static SecurityRequirement readSecurityRequirement(AnnotationInstance annotationInstance) {
        SecurityRequirementImpl requirement = new SecurityRequirementImpl();
        SecurityRequirementReader.addSecurityRequirement(requirement, annotationInstance);
        if (requirement.getSchemes().isEmpty()) {
            return null;
        }
        return requirement;
    }

    public static SecurityRequirement readSecurityRequirementsSet(AnnotationInstance annotationInstance) {
        AnnotationValue value = annotationInstance.value();
        SecurityRequirementImpl requirement = new SecurityRequirementImpl();
        if (value != null) {
            for (AnnotationInstance securityRequirementInstance : value.asNestedArray()) {
                SecurityRequirementReader.addSecurityRequirement(requirement, securityRequirementInstance);
            }
        }
        return requirement;
    }

    private static void addSecurityRequirement(SecurityRequirement requirement, AnnotationInstance annotationInstance) {
        String name = (String)Annotations.value(annotationInstance, "name");
        if (name != null) {
            String[] scopes = (String[])Annotations.value(annotationInstance, "scopes");
            if (scopes != null) {
                requirement.addScheme(name, new ArrayList<String>(Arrays.asList(scopes)));
            } else {
                requirement.addScheme(name);
            }
        }
    }

    private static SecurityRequirement readSecurityRequirement(JsonNode node) {
        if (node != null && node.isObject()) {
            SecurityRequirementImpl requirement = new SecurityRequirementImpl();
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode scopesNode = node.get(fieldName);
                Optional<List<String>> maybeScopes = JsonUtil.readStringArray(scopesNode);
                if (maybeScopes.isPresent()) {
                    requirement.addScheme(fieldName, maybeScopes.get());
                    continue;
                }
                requirement.addScheme(fieldName);
            }
            return requirement;
        }
        return null;
    }

    public static AnnotationInstance getSecurityRequirementsAnnotation(AnnotationTarget target) {
        return Annotations.getAnnotation(target, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENTS);
    }

    public static List<AnnotationInstance> getSecurityRequirementAnnotations(AnnotationTarget target) {
        return Annotations.getRepeatableAnnotation(target, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENT, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENTS);
    }

    public static AnnotationInstance getSecurityRequirementsSetsAnnotation(AnnotationTarget target) {
        return Annotations.getAnnotation(target, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENTS_SETS);
    }

    public static List<AnnotationInstance> getSecurityRequirementsSetAnnotations(AnnotationTarget target) {
        return Annotations.getRepeatableAnnotation(target, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENTS_SET, SecurityRequirementConstant.DOTNAME_SECURITY_REQUIREMENTS_SETS);
    }
}

