/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.log4j2;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="Field", category="Core", printObject=true)
public class GelfLogField {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private String name;
    private String literal;
    private String mdc;
    private PatternLayout patternLayout;

    public GelfLogField(String name, String literal, String mdc, PatternLayout patternLayout) {
        this.name = name;
        this.literal = literal;
        this.mdc = mdc;
        this.patternLayout = patternLayout;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getMdc() {
        return this.mdc;
    }

    public PatternLayout getPatternLayout() {
        return this.patternLayout;
    }

    @PluginFactory
    public static GelfLogField createField(@PluginConfiguration Configuration config, @PluginAttribute(value="name") String name, @PluginAttribute(value="literal") String literalValue, @PluginAttribute(value="mdc") String mdc, @PluginAttribute(value="pattern") String pattern) {
        boolean isPattern = Strings.isNotEmpty((CharSequence)pattern);
        boolean isLiteralValue = Strings.isNotEmpty((CharSequence)literalValue);
        boolean isMDC = Strings.isNotEmpty((CharSequence)mdc);
        if (Strings.isEmpty((CharSequence)name)) {
            LOGGER.error("The name is empty");
            return null;
        }
        if (isPattern && isLiteralValue || isPattern && isMDC || isLiteralValue && isMDC) {
            LOGGER.error("The pattern, literal, and mdc attributes are mutually exclusive.");
            return null;
        }
        if (isPattern) {
            PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(pattern).withConfiguration(config).withNoConsoleNoAnsi(false).withAlwaysWriteExceptions(false).build();
            return new GelfLogField(name, null, null, patternLayout);
        }
        return new GelfLogField(name, literalValue, mdc, null);
    }
}

