/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme.beans;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.keycloak.theme.TemplatingUtil;

public class MessageFormatterMethod
implements TemplateMethodModelEx {
    private final Properties messages;
    private final Locale locale;

    public MessageFormatterMethod(Locale locale, Properties messages) {
        this.locale = locale;
        this.messages = messages;
    }

    public Object exec(List list) throws TemplateModelException {
        if (list.size() >= 1) {
            List<Object> resolved = this.resolve(list.subList(1, list.size()));
            String key = list.get(0).toString();
            return new MessageFormat(this.messages.getProperty(key, key), this.locale).format(resolved.toArray());
        }
        return null;
    }

    private List<Object> resolve(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : list) {
            if (item instanceof SimpleScalar) {
                item = ((SimpleScalar)item).getAsString();
            }
            if (item instanceof String) {
                result.add(TemplatingUtil.resolveVariables((String)item, this.messages));
                continue;
            }
            result.add(item);
        }
        return result;
    }
}

