/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ThemeManager;
import org.keycloak.theme.DefaultThemeManager;
import org.keycloak.theme.Theme;

public class DefaultThemeManagerFactory {
    private static final Logger log = Logger.getLogger(DefaultThemeManagerFactory.class);
    private ConcurrentHashMap<ThemeKey, Theme> themeCache;

    public DefaultThemeManagerFactory() {
        if (Config.scope((String[])new String[]{"theme"}).getBoolean("cacheThemes", Boolean.valueOf(true)).booleanValue()) {
            this.themeCache = new ConcurrentHashMap();
        }
    }

    public ThemeManager create(KeycloakSession session) {
        return new DefaultThemeManager(this, session);
    }

    public Theme getCachedTheme(String name, Theme.Type type) {
        if (this.themeCache != null) {
            ThemeKey key = ThemeKey.get(name, type);
            return this.themeCache.get(key);
        }
        return null;
    }

    public Theme addCachedTheme(String name, Theme.Type type, Theme theme) {
        if (theme == null) {
            return null;
        }
        if (this.themeCache == null) {
            return theme;
        }
        ThemeKey key = ThemeKey.get(name, type);
        if (this.themeCache.putIfAbsent(key, theme) != null) {
            theme = this.themeCache.get(key);
        }
        return theme;
    }

    public boolean isCacheEnabled() {
        return this.themeCache != null;
    }

    public void clearCache() {
        if (this.themeCache != null) {
            this.themeCache.clear();
            log.info((Object)"Cleared theme cache");
        }
    }

    public static class ThemeKey {
        private String name;
        private Theme.Type type;

        public static ThemeKey get(String name, Theme.Type type) {
            return new ThemeKey(name, type);
        }

        private ThemeKey(String name, Theme.Type type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Theme.Type getType() {
            return this.type;
        }

        public void setType(Theme.Type type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThemeKey themeKey = (ThemeKey)o;
            if (this.name != null ? !this.name.equals(themeKey.name) : themeKey.name != null) {
                return false;
            }
            return this.type == themeKey.type;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

