/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.openshift;

import java.util.List;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class OpenshiftV4IdentityProviderConfig
extends OAuth2IdentityProviderConfig {
    private static final String BASE_URL = "baseUrl";

    public OpenshiftV4IdentityProviderConfig(IdentityProviderModel identityProviderModel) {
        super(identityProviderModel);
    }

    public OpenshiftV4IdentityProviderConfig() {
    }

    private String trimTrailingSlash(String baseUrl) {
        if (baseUrl != null && baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    public String getBaseUrl() {
        return (String)this.getConfig().get(BASE_URL);
    }

    public void setBaseUrl(String baseUrl) {
        this.getConfig().put(BASE_URL, this.trimTrailingSlash(baseUrl));
    }

    public static List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name(BASE_URL).label("Base URL").helpText("Override the default Base URL for this identity provider.").type("String").add().build();
    }
}

