/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminConsole;
import org.keycloak.services.resources.admin.AdminCorsPreflightService;
import org.keycloak.services.resources.admin.RealmsAdminResource;
import org.keycloak.services.resources.admin.RealmsAdminResourcePreflight;
import org.keycloak.services.resources.admin.info.ServerInfoAdminResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.theme.Theme;
import org.keycloak.urls.UrlType;

@Path(value="/admin")
public class AdminRoot {
    protected static final Logger logger = Logger.getLogger(AdminRoot.class);
    protected TokenManager tokenManager = new TokenManager();
    @Context
    protected KeycloakSession session;

    public static UriBuilder adminBaseUrl(UriInfo uriInfo) {
        return AdminRoot.adminBaseUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder adminBaseUrl(UriBuilder base) {
        return base.path(AdminRoot.class);
    }

    @GET
    @Operation(hidden=true)
    public Response masterRealmAdminConsoleRedirect() {
        if (!AdminRoot.isAdminConsoleEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        RealmModel master = new RealmManager(this.session).getKeycloakAdminstrationRealm();
        return Response.status((int)302).location(this.session.getContext().getUri(UrlType.ADMIN).getBaseUriBuilder().path(AdminRoot.class).path(AdminRoot.class, "getAdminConsole").path("/").build(new Object[]{master.getName()})).build();
    }

    @Path(value="index.{html:html}")
    @GET
    @Operation(hidden=true)
    public Response masterRealmAdminConsoleRedirectHtml() {
        if (!AdminRoot.isAdminConsoleEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return this.masterRealmAdminConsoleRedirect();
    }

    protected void resolveRealmAndUpdateSession(String name, KeycloakSession session) {
        RealmManager realmManager = new RealmManager(session);
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("Realm not found.  Did you type in a bad URL?");
        }
        session.getContext().setRealm(realm);
    }

    public static UriBuilder adminConsoleUrl(UriInfo uriInfo) {
        return AdminRoot.adminConsoleUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder adminConsoleUrl(UriBuilder base) {
        return AdminRoot.adminBaseUrl(base).path(AdminRoot.class, "getAdminConsole");
    }

    @Path(value="{realm}/console")
    @Operation(hidden=true)
    public AdminConsole getAdminConsole(@PathParam(value="realm") String name) {
        if (!AdminRoot.isAdminConsoleEnabled()) {
            throw new NotFoundException();
        }
        this.resolveRealmAndUpdateSession(name, this.session);
        return new AdminConsole(this.session);
    }

    protected AdminAuth authenticateRealmAdminRequest(HttpHeaders headers) {
        AccessToken token;
        String tokenString = AppAuthManager.extractAuthorizationHeaderToken(headers);
        if (tokenString == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        try {
            JWSInput input = new JWSInput(tokenString);
            token = (AccessToken)input.readJsonContent(AccessToken.class);
        }
        catch (JWSInputException e) {
            throw new NotAuthorizedException((Object)"Bearer token format error", new Object[0]);
        }
        String realmName = token.getIssuer().substring(token.getIssuer().lastIndexOf(47) + 1);
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            throw new NotAuthorizedException((Object)"Unknown realm in token", new Object[0]);
        }
        this.session.getContext().setRealm(realm);
        AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(this.session).setRealm(realm).setConnection(this.session.getContext().getConnection()).setHeaders(headers).authenticate();
        if (authResult == null) {
            logger.debug((Object)"Token not valid");
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        return new AdminAuth(realm, authResult.getToken(), authResult.getUser(), authResult.getClient());
    }

    public static UriBuilder realmsUrl(UriInfo uriInfo) {
        return AdminRoot.realmsUrl(uriInfo.getBaseUriBuilder());
    }

    public static UriBuilder realmsUrl(UriBuilder base) {
        return AdminRoot.adminBaseUrl(base).path(AdminRoot.class, "getRealmsAdmin");
    }

    @Path(value="realms")
    public RealmsAdminResource getRealmsAdmin() {
        HttpRequest request = this.getHttpRequest();
        if (!AdminRoot.isAdminApiEnabled()) {
            throw new NotFoundException();
        }
        if (request.getHttpMethod().equals("OPTIONS")) {
            return new RealmsAdminResourcePreflight(this.session, null, this.tokenManager, request);
        }
        AdminAuth auth = this.authenticateRealmAdminRequest(this.session.getContext().getRequestHeaders());
        if (auth != null) {
            logger.debug((Object)("authenticated admin access for: " + auth.getUser().getUsername()));
        }
        HttpResponse response = this.getHttpResponse();
        Cors.add(request).allowedOrigins(auth.getToken()).allowedMethods("GET", "PUT", "POST", "DELETE").exposedHeaders("Location").auth().build(response);
        return new RealmsAdminResource(this.session, auth, this.tokenManager);
    }

    @Path(value="{any:.*}")
    @OPTIONS
    @Operation(hidden=true)
    public Object preFlight() {
        HttpRequest request = this.getHttpRequest();
        if (!AdminRoot.isAdminApiEnabled()) {
            throw new NotFoundException();
        }
        return new AdminCorsPreflightService(request);
    }

    @Path(value="serverinfo")
    public Object getServerInfo() {
        if (!AdminRoot.isAdminApiEnabled()) {
            throw new NotFoundException();
        }
        HttpRequest request = this.getHttpRequest();
        if (request.getHttpMethod().equals("OPTIONS")) {
            return new AdminCorsPreflightService(request);
        }
        AdminAuth auth = this.authenticateRealmAdminRequest(this.session.getContext().getRequestHeaders());
        if (!AdminPermissions.realms(this.session, auth).isAdmin()) {
            throw new ForbiddenException();
        }
        if (auth != null) {
            logger.debug((Object)("authenticated admin access for: " + auth.getUser().getUsername()));
        }
        Cors.add(request).allowedOrigins(auth.getToken()).allowedMethods("GET", "PUT", "POST", "DELETE").auth().build(this.getHttpResponse());
        return new ServerInfoAdminResource(this.session);
    }

    private HttpResponse getHttpResponse() {
        return this.session.getContext().getHttpResponse();
    }

    private HttpRequest getHttpRequest() {
        return this.session.getContext().getHttpRequest();
    }

    public static Theme getTheme(KeycloakSession session, RealmModel realm) throws IOException {
        return session.theme().getTheme(Theme.Type.ADMIN);
    }

    public static Properties getMessages(KeycloakSession session, RealmModel realm, String lang) {
        try {
            Theme theme = AdminRoot.getTheme(session, realm);
            Locale locale = lang != null ? Locale.forLanguageTag(lang) : Locale.ENGLISH;
            return theme.getMessages(locale);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to load messages from theme", (Throwable)e);
            return new Properties();
        }
    }

    public static Properties getMessages(KeycloakSession session, RealmModel realm, String lang, String ... bundles) {
        Properties compound = new Properties();
        for (String bundle : bundles) {
            Properties current = AdminRoot.getMessages(session, realm, lang, bundle);
            compound.putAll((Map<?, ?>)current);
        }
        return compound;
    }

    private static Properties getMessages(KeycloakSession session, RealmModel realm, String lang, String bundle) {
        try {
            Theme theme = AdminRoot.getTheme(session, realm);
            Locale locale = lang != null ? Locale.forLanguageTag(lang) : Locale.ENGLISH;
            return theme.getMessages(bundle, locale);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to load messages from theme", (Throwable)e);
            return new Properties();
        }
    }

    private static boolean isAdminApiEnabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_API);
    }

    private static boolean isAdminConsoleEnabled() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN2);
    }
}

