/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.WebOriginsUtils;
import org.keycloak.representations.AccessToken;

public class Cors {
    private static final Logger logger = Logger.getLogger(Cors.class);
    public static final long DEFAULT_MAX_AGE = TimeUnit.HOURS.toSeconds(1L);
    public static final String DEFAULT_ALLOW_METHODS = "GET, HEAD, OPTIONS";
    public static final String DEFAULT_ALLOW_HEADERS = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers, DPoP";
    public static final String ORIGIN_HEADER = "Origin";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD = "*";
    public static final String INCLUDE_REDIRECTS = "+";
    private HttpRequest request;
    private Response.ResponseBuilder builder;
    private Set<String> allowedOrigins;
    private Set<String> allowedMethods;
    private Set<String> exposedHeaders;
    private boolean preflight;
    private boolean auth;

    public Cors(HttpRequest request, Response.ResponseBuilder response) {
        this.request = request;
        this.builder = response;
    }

    public Cors(HttpRequest request) {
        this.request = request;
    }

    public static Cors add(HttpRequest request, Response.ResponseBuilder response) {
        return new Cors(request, response);
    }

    public static Cors add(HttpRequest request) {
        return new Cors(request);
    }

    public Cors builder(Response.ResponseBuilder builder) {
        this.builder = builder;
        return this;
    }

    public Cors preflight() {
        this.preflight = true;
        return this;
    }

    public Cors auth() {
        this.auth = true;
        return this;
    }

    public Cors allowAllOrigins() {
        this.allowedOrigins = Collections.singleton(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD);
        return this;
    }

    public Cors allowedOrigins(KeycloakSession session, ClientModel client) {
        if (client != null) {
            this.allowedOrigins = WebOriginsUtils.resolveValidWebOrigins(session, client);
        }
        return this;
    }

    public Cors allowedOrigins(AccessToken token) {
        if (token != null) {
            this.allowedOrigins = token.getAllowedOrigins();
        }
        return this;
    }

    public Cors allowedOrigins(String ... allowedOrigins) {
        if (allowedOrigins != null && allowedOrigins.length > 0) {
            this.allowedOrigins = new HashSet<String>(Arrays.asList(allowedOrigins));
        }
        return this;
    }

    public Cors allowedMethods(String ... allowedMethods) {
        this.allowedMethods = new HashSet<String>(Arrays.asList(allowedMethods));
        return this;
    }

    public Cors exposedHeaders(String ... exposedHeaders) {
        this.exposedHeaders = new HashSet<String>(Arrays.asList(exposedHeaders));
        return this;
    }

    public Response build() {
        this.build((arg_0, arg_1) -> ((Response.ResponseBuilder)this.builder).header(arg_0, arg_1));
        logger.debug((Object)"Added CORS headers to response");
        return this.builder.build();
    }

    public void build(HttpResponse response) {
        this.build((arg_0, arg_1) -> ((HttpResponse)response).addHeader(arg_0, arg_1));
        logger.debug((Object)"Added CORS headers to response");
    }

    public void build(BiConsumer<String, String> addHeader) {
        String origin = (String)this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)ORIGIN_HEADER);
        if (origin == null) {
            logger.trace((Object)"No origin header ignoring");
            return;
        }
        if (!(this.preflight || this.allowedOrigins != null && (this.allowedOrigins.contains(origin) || this.allowedOrigins.contains(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD)))) {
            if (logger.isDebugEnabled()) {
                logger.debugv("Invalid CORS request: origin {0} not in allowed origins {1}", (Object)origin, this.allowedOrigins);
            }
            return;
        }
        addHeader.accept(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        if (this.preflight) {
            if (this.allowedMethods != null) {
                addHeader.accept(ACCESS_CONTROL_ALLOW_METHODS, CollectionUtil.join(this.allowedMethods));
            } else {
                addHeader.accept(ACCESS_CONTROL_ALLOW_METHODS, DEFAULT_ALLOW_METHODS);
            }
        }
        if (!this.preflight && this.exposedHeaders != null) {
            addHeader.accept(ACCESS_CONTROL_EXPOSE_HEADERS, CollectionUtil.join(this.exposedHeaders));
        }
        addHeader.accept(ACCESS_CONTROL_ALLOW_CREDENTIALS, Boolean.toString(this.auth));
        if (this.preflight) {
            if (this.auth) {
                addHeader.accept(ACCESS_CONTROL_ALLOW_HEADERS, String.format("%s, %s", DEFAULT_ALLOW_HEADERS, AUTHORIZATION_HEADER));
            } else {
                addHeader.accept(ACCESS_CONTROL_ALLOW_HEADERS, DEFAULT_ALLOW_HEADERS);
            }
        }
        if (this.preflight) {
            addHeader.accept(ACCESS_CONTROL_MAX_AGE, String.valueOf(DEFAULT_MAX_AGE));
        }
    }
}

