/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.SecureClientAuthenticatorExecutor;

public class SecureClientAuthenticatorExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "secure-client-authenticator";
    public static final String ALLOWED_CLIENT_AUTHENTICATORS = "allowed-client-authenticators";
    public static final String DEFAULT_CLIENT_AUTHENTICATOR = "default-client-authenticator";
    private List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new SecureClientAuthenticatorExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        List clientAuthProviders = factory.getProviderFactoriesStream(ClientAuthenticator.class).map(ProviderFactory::getId).collect(Collectors.toList());
        ProviderConfigProperty allowedClientAuthenticatorsProperty = new ProviderConfigProperty(ALLOWED_CLIENT_AUTHENTICATORS, "Allowed Client Authenticators", "List of available client authentication methods, which are allowed for clients to use. Other client authentication methods will not be allowed.", "MultivaluedList", null);
        allowedClientAuthenticatorsProperty.setOptions(clientAuthProviders);
        ProviderConfigProperty autoConfiguredClientAuthenticator = new ProviderConfigProperty(DEFAULT_CLIENT_AUTHENTICATOR, "Default Client Authenticator", "This client authentication method will be set as the authentication method to new clients during register/update request of the client in case that client does not have explicitly set other client authenticator method. If it is not set, then the client authenticator won't be set on new clients. Regardless the value of this option, client is still always validated to match with any of the allowed client authentication methods", "List", (Object)"client-jwt");
        autoConfiguredClientAuthenticator.setOptions(clientAuthProviders);
        this.configProperties = Arrays.asList(allowedClientAuthenticatorsProperty, autoConfiguredClientAuthenticator);
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "It makes the client enforce registering/updating secure client authentication.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.configProperties;
    }
}

