/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.connections.httpclient.ProxyMappings;
import org.keycloak.connections.httpclient.ProxyMappingsAwareRoutePlanner;

public class HttpClientBuilder {
    protected KeyStore truststore;
    protected KeyStore clientKeyStore;
    protected String clientPrivateKeyPassword;
    protected boolean disableTrustManager;
    protected HostnameVerificationPolicy policy = HostnameVerificationPolicy.WILDCARD;
    protected SSLContext sslContext;
    protected int connectionPoolSize = 128;
    protected int maxPooledPerRoute = 64;
    protected long connectionTTL = -1L;
    protected boolean reuseConnections = true;
    protected TimeUnit connectionTTLUnit = TimeUnit.MILLISECONDS;
    protected long maxConnectionIdleTime = 900000L;
    protected TimeUnit maxConnectionIdleTimeUnit = TimeUnit.MILLISECONDS;
    protected HostnameVerifier verifier = null;
    protected long socketTimeout = -1L;
    protected TimeUnit socketTimeoutUnits = TimeUnit.MILLISECONDS;
    protected long establishConnectionTimeout = -1L;
    protected TimeUnit establishConnectionTimeoutUnits = TimeUnit.MILLISECONDS;
    protected boolean disableCookies = false;
    protected ProxyMappings proxyMappings;
    protected boolean expectContinueEnabled = false;

    public HttpClientBuilder socketTimeout(long timeout, TimeUnit unit) {
        this.socketTimeout = timeout;
        this.socketTimeoutUnits = unit;
        return this;
    }

    public HttpClientBuilder establishConnectionTimeout(long timeout, TimeUnit unit) {
        this.establishConnectionTimeout = timeout;
        this.establishConnectionTimeoutUnits = unit;
        return this;
    }

    public HttpClientBuilder connectionTTL(long ttl, TimeUnit unit) {
        this.connectionTTL = ttl;
        this.connectionTTLUnit = unit;
        return this;
    }

    public HttpClientBuilder reuseConnections(boolean reuseConnections) {
        this.reuseConnections = reuseConnections;
        return this;
    }

    public HttpClientBuilder maxConnectionIdleTime(long maxConnectionIdleTime, TimeUnit unit) {
        this.maxConnectionIdleTime = maxConnectionIdleTime;
        this.maxConnectionIdleTimeUnit = unit;
        return this;
    }

    public HttpClientBuilder maxPooledPerRoute(int maxPooledPerRoute) {
        this.maxPooledPerRoute = maxPooledPerRoute;
        return this;
    }

    public HttpClientBuilder connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public HttpClientBuilder disableTrustManager() {
        this.disableTrustManager = true;
        return this;
    }

    public HttpClientBuilder disableCookies(boolean disable) {
        this.disableCookies = disable;
        return this;
    }

    public HttpClientBuilder hostnameVerification(HostnameVerificationPolicy policy) {
        this.policy = policy;
        return this;
    }

    public HttpClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public HttpClientBuilder trustStore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    public HttpClientBuilder keyStore(KeyStore keyStore, String password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = password;
        return this;
    }

    public HttpClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = new String(password);
        return this;
    }

    public HttpClientBuilder proxyMappings(ProxyMappings proxyMappings) {
        this.proxyMappings = proxyMappings;
        return this;
    }

    public HttpClientBuilder expectContinueEnabled(boolean expectContinueEnabled) {
        this.expectContinueEnabled = expectContinueEnabled;
        return this;
    }

    public CloseableHttpClient build() {
        VerifierWrapper verifier = null;
        if (this.verifier != null) {
            verifier = new VerifierWrapper(this.verifier);
        } else {
            switch (this.policy) {
                case ANY: {
                    verifier = new AllowAllHostnameVerifier();
                    break;
                }
                case WILDCARD: {
                    verifier = new BrowserCompatHostnameVerifier();
                    break;
                }
                case STRICT: {
                    verifier = new StrictHostnameVerifier();
                }
            }
        }
        try {
            SSLConnectionSocketFactory sslsf = null;
            SSLContext theContext = this.sslContext;
            if (this.disableTrustManager) {
                theContext = SSLContext.getInstance("TLS");
                theContext.init(null, new TrustManager[]{new PassthroughTrustManager()}, new SecureRandom());
                verifier = new AllowAllHostnameVerifier();
                sslsf = new SSLConnectionSocketFactory(theContext, (X509HostnameVerifier)verifier);
            } else if (theContext != null) {
                sslsf = new SSLConnectionSocketFactory(theContext, (X509HostnameVerifier)verifier);
            } else if (this.clientKeyStore != null || this.truststore != null) {
                theContext = this.createSslContext("TLS", this.clientKeyStore, this.clientPrivateKeyPassword, this.truststore, null);
                sslsf = new SSLConnectionSocketFactory(theContext, (X509HostnameVerifier)verifier);
            } else {
                SSLContext tlsContext = SSLContext.getInstance("TLS");
                tlsContext.init(null, null, null);
                sslsf = new SSLConnectionSocketFactory(tlsContext, (X509HostnameVerifier)verifier);
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)this.establishConnectionTimeout).setSocketTimeout((int)this.socketTimeout).setExpectContinueEnabled(this.expectContinueEnabled).build();
            org.apache.http.impl.client.HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setMaxConnTotal(this.connectionPoolSize).setMaxConnPerRoute(this.maxPooledPerRoute).setConnectionTimeToLive(this.connectionTTL, this.connectionTTLUnit);
            if (!this.reuseConnections) {
                builder.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
            }
            if (this.proxyMappings != null && !this.proxyMappings.isEmpty()) {
                builder.setRoutePlanner((HttpRoutePlanner)new ProxyMappingsAwareRoutePlanner(this.proxyMappings));
            }
            if (this.maxConnectionIdleTime > 0L) {
                builder.evictIdleConnections(this.maxConnectionIdleTime, this.maxConnectionIdleTimeUnit);
            }
            if (this.disableCookies) {
                builder.disableCookieManagement();
            }
            if (!this.reuseConnections) {
                builder.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SSLContext createSslContext(String algorithm, KeyStore keystore, String keyPassword, KeyStore truststore, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        return SSLContexts.custom().useProtocol(algorithm).setSecureRandom(random).loadKeyMaterial(keystore, keyPassword != null ? keyPassword.toCharArray() : null).loadTrustMaterial(truststore).build();
    }

    public static enum HostnameVerificationPolicy {
        ANY,
        WILDCARD,
        STRICT;

    }

    static class VerifierWrapper
    implements X509HostnameVerifier {
        protected HostnameVerifier verifier;

        VerifierWrapper(HostnameVerifier verifier) {
            this.verifier = verifier;
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
            if (!this.verifier.verify(host, ssl.getSession())) {
                throw new SSLException("Hostname verification failure");
            }
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            throw new SSLException("This verification path not implemented");
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            throw new SSLException("This verification path not implemented");
        }

        public boolean verify(String s, SSLSession sslSession) {
            return this.verifier.verify(s, sslSession);
        }
    }

    private static class PassthroughTrustManager
    implements X509TrustManager {
        private PassthroughTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

