/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.updateemail.UpdateEmailActionToken;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsPages;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.Templates;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.services.Urls;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.EventAuditingAttributeChangeListener;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class UpdateEmail
implements RequiredActionProvider,
RequiredActionFactory,
EnvironmentDependentProviderFactory {
    private static final Logger logger = Logger.getLogger(UpdateEmail.class);

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public String getDisplayText() {
        return "Update Email";
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        context.challenge(context.form().createResponse(UserModel.RequiredAction.UPDATE_EMAIL));
    }

    public void processAction(RequiredActionContext context) {
        UserProfile emailUpdateValidationResult;
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String newEmail = (String)formData.getFirst((Object)"email");
        RealmModel realm = context.getRealm();
        UserModel user = context.getUser();
        try {
            emailUpdateValidationResult = UpdateEmail.validateEmailUpdate(context.getSession(), user, newEmail);
        }
        catch (ValidationException pve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(pve.getErrors());
            context.challenge(context.form().setErrors(errors).setFormData(formData).createResponse(UserModel.RequiredAction.UPDATE_EMAIL));
            return;
        }
        boolean logoutSessions = "on".equals(formData.getFirst((Object)"logout-sessions"));
        if (!realm.isVerifyEmail() || Validation.isBlank(newEmail) || Objects.equals(user.getEmail(), newEmail) && user.isEmailVerified()) {
            if (logoutSessions) {
                AuthenticatorUtil.logoutOtherSessions(context);
            }
            this.updateEmailWithoutConfirmation(context, emailUpdateValidationResult);
            return;
        }
        this.sendEmailUpdateConfirmation(context, logoutSessions);
    }

    private void sendEmailUpdateConfirmation(RequiredActionContext context, boolean logoutSessions) {
        UserModel user = context.getUser();
        String oldEmail = user.getEmail();
        String newEmail = (String)context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"email");
        RealmModel realm = context.getRealm();
        int validityInSecs = realm.getActionTokenGeneratedByUserLifespan("update-email");
        UriInfo uriInfo = context.getUriInfo();
        KeycloakSession session = context.getSession();
        AuthenticationSessionModel authenticationSession = context.getAuthenticationSession();
        UpdateEmailActionToken actionToken = new UpdateEmailActionToken(user.getId(), Time.currentTime() + validityInSecs, oldEmail, newEmail, authenticationSession.getClient().getClientId(), logoutSessions);
        String link = Urls.actionTokenBuilder(uriInfo.getBaseUri(), actionToken.serialize(session, realm, uriInfo), authenticationSession.getClient().getClientId(), authenticationSession.getTabId()).build(new Object[]{realm.getName()}).toString();
        context.getEvent().event(EventType.SEND_VERIFY_EMAIL).detail("email", newEmail);
        try {
            ((EmailTemplateProvider)session.getProvider(EmailTemplateProvider.class)).setAuthenticationSession(authenticationSession).setRealm(realm).setUser(user).sendEmailUpdateConfirmation(link, TimeUnit.SECONDS.toMinutes(validityInSecs), newEmail);
        }
        catch (EmailException e) {
            logger.error((Object)"Failed to send email for email update", (Throwable)e);
            context.getEvent().error("email_send_failed");
            return;
        }
        context.getEvent().success();
        LoginFormsProvider forms = context.form();
        context.challenge(forms.setAttribute("messageHeader", (Object)forms.getMessage("emailUpdateConfirmationSentTitle")).setInfo("emailUpdateConfirmationSent", new Object[]{newEmail}).createForm(Templates.getTemplate(LoginFormsPages.INFO)));
    }

    private void updateEmailWithoutConfirmation(RequiredActionContext context, UserProfile emailUpdateValidationResult) {
        UpdateEmail.updateEmailNow(context.getEvent(), context.getUser(), emailUpdateValidationResult);
        context.success();
    }

    public static UserProfile validateEmailUpdate(KeycloakSession session, UserModel user, String newEmail) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.putSingle((Object)"username", (Object)user.getUsername());
        formData.putSingle((Object)"email", (Object)newEmail);
        UserProfileProvider profileProvider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UserProfile profile = profileProvider.create(UserProfileContext.UPDATE_EMAIL, (Map)formData, user);
        profile.validate();
        return profile;
    }

    public static void updateEmailNow(EventBuilder event, UserModel user, UserProfile emailUpdateValidationResult) {
        String oldEmail = user.getEmail();
        String newEmail = emailUpdateValidationResult.getAttributes().getFirstValue("email");
        event.event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", newEmail);
        emailUpdateValidationResult.update(false, new AttributeChangeListener[]{new EventAuditingAttributeChangeListener(emailUpdateValidationResult, event)});
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_EMAIL.name();
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL);
    }
}

