/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd.impl;

import org.jboss.logging.Logger;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;

public class PAMAuthenticator {
    private static final String PAM_SERVICE = "keycloak";
    private static final Logger logger = Logger.getLogger(PAMAuthenticator.class);
    private final String username;
    private final String[] factors;

    public PAMAuthenticator(String username, String ... factors) {
        this.username = username;
        this.factors = factors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnixUser authenticate() {
        PAM pam = null;
        UnixUser user = null;
        try {
            pam = new PAM(PAM_SERVICE);
            user = pam.authenticate(this.username, this.factors);
        }
        catch (PAMException e) {
            logger.error((Object)"Authentication failed", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            pam.dispose();
        }
        return user;
    }
}

