/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AccessibleBufferOutputStream
extends FilterOutputStream {
    private byte[] buf;

    public AccessibleBufferOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.buf = new byte[]{(byte)b};
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.buf = new byte[len];
        System.arraycopy(b, off, this.buf, 0, len);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLastByte() {
        if (this.buf != null && this.buf.length > 0) {
            return 0xFF & this.buf[this.buf.length - 1];
        }
        return -1;
    }
}

