/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Iterator;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.CloseableIterator;

public class ConcatIterator<E>
extends AbstractIterator<E>
implements CloseableIterator<E> {
    private final Iterator<? extends Iterable<E>> iterables;
    private Iterator<E> currentIterator;

    public ConcatIterator(Iterable<? extends Iterable<E>> iterableIterables) {
        this.iterables = iterableIterables.iterator();
        if (this.iterables.hasNext()) {
            this.currentIterator = this.iterables.next().iterator();
        }
    }

    @Override
    protected E getNext() {
        E next = null;
        if (this.currentIterator != null) {
            while (next == null) {
                if (this.currentIterator.hasNext()) {
                    next = this.currentIterator.next();
                    continue;
                }
                ConcatIterator.closeIterator(this.currentIterator);
                if (this.iterables.hasNext()) {
                    this.currentIterator = this.iterables.next().iterator();
                    continue;
                }
                this.currentIterator = null;
                break;
            }
        }
        return next;
    }

    @Override
    public void close() {
        ConcatIterator.closeIterator(this.currentIterator);
    }

    @Override
    public void remove() {
        if (this.currentIterator != null) {
            this.currentIterator.remove();
        }
    }

    private static void closeIterator(Iterator<?> iter) {
        if (iter instanceof CloseableIterator) {
            ((CloseableIterator)iter).close();
        }
    }
}

