/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.timer.ScheduledTask;

public class ClearExpiredEvents
implements ScheduledTask {
    protected static final Logger logger = Logger.getLogger(ClearExpiredEvents.class);

    public void run(KeycloakSession session) {
        long currentTimeMillis = Time.currentTimeMillis();
        EventStoreProvider eventStore = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
        if (eventStore != null) {
            eventStore.clearExpiredEvents();
        }
        long took = Time.currentTimeMillis() - currentTimeMillis;
        logger.debugf("ClearExpiredEvents finished in %d ms", took);
    }
}

