/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.List;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class JdbcValuesCacheHit
extends AbstractJdbcValues {
    private static final Object[][] NO_DATA = new Object[0][];
    private Object[][] cachedData;
    private final int numberOfRows;
    private final JdbcValuesMapping resolvedMapping;
    private int position = -1;

    public JdbcValuesCacheHit(Object[][] cachedData, JdbcValuesMapping resolvedMapping) {
        this.cachedData = cachedData;
        this.numberOfRows = cachedData.length;
        this.resolvedMapping = resolvedMapping;
    }

    public JdbcValuesCacheHit(List<?> cachedResults, JdbcValuesMapping resolvedMapping) {
        this(JdbcValuesCacheHit.extractData(cachedResults), resolvedMapping);
    }

    private static Object[][] extractData(List<?> cachedResults) {
        Object[][] data;
        if (CollectionHelper.isEmpty(cachedResults)) {
            return NO_DATA;
        }
        if (cachedResults.get(0) instanceof JdbcValuesMetadata) {
            int end = cachedResults.size() - 1;
            data = new Object[end][];
            for (int i = 0; i < end; ++i) {
                Object[] row = (Object[])cachedResults.get(i + 1);
                data[i] = row;
            }
        } else {
            data = new Object[cachedResults.size()][];
            for (int i = 0; i < cachedResults.size(); ++i) {
                Object[] row = (Object[])cachedResults.get(i);
                data[i] = row;
            }
        }
        return data;
    }

    @Override
    protected boolean processNext(RowProcessingState rowProcessingState) {
        ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("JdbcValuesCacheHit#processNext : position = %i; numberOfRows = %i", this.position, this.numberOfRows);
        ++this.position;
        if (this.position >= this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    protected boolean processPrevious(RowProcessingState rowProcessingState) {
        ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("JdbcValuesCacheHit#processPrevious : position = %i; numberOfRows = %i", this.position, this.numberOfRows);
        --this.position;
        if (this.position >= this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    protected boolean processScroll(int numberOfRows, RowProcessingState rowProcessingState) {
        ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("JdbcValuesCacheHit#processScroll(%i) : position = %i; numberOfRows = %i", numberOfRows, this.position, this.numberOfRows);
        this.position += numberOfRows;
        if (this.position > this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    protected boolean processPosition(int position, RowProcessingState rowProcessingState) {
        ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("JdbcValuesCacheHit#processPosition(%i) : position = %i; numberOfRows = %i", position, this.position, this.numberOfRows);
        if (position < 0) {
            int newPosition = this.numberOfRows + position;
            ResultsLogger.RESULTS_MESSAGE_LOGGER.debugf("Translated negative absolute position `%i` into `%i` based on `%i` number of rows", position, newPosition, this.numberOfRows);
            position = newPosition;
        }
        if (position > this.numberOfRows) {
            ResultsLogger.RESULTS_MESSAGE_LOGGER.debugf("Absolute position `%i` exceeded number of rows `%i`", position, this.numberOfRows);
            this.position = this.numberOfRows;
            return false;
        }
        this.position = position;
        return true;
    }

    @Override
    public boolean isBeforeFirst(RowProcessingState rowProcessingState) {
        return this.position < 0;
    }

    @Override
    public void beforeFirst(RowProcessingState rowProcessingState) {
        this.position = -1;
    }

    @Override
    public boolean isFirst(RowProcessingState rowProcessingState) {
        return this.position == 0;
    }

    @Override
    public boolean first(RowProcessingState rowProcessingState) {
        this.position = 0;
        return this.numberOfRows > 0;
    }

    @Override
    public boolean isAfterLast(RowProcessingState rowProcessingState) {
        return this.position >= this.numberOfRows;
    }

    @Override
    public void afterLast(RowProcessingState rowProcessingState) {
        this.position = this.numberOfRows;
    }

    @Override
    public boolean isLast(RowProcessingState rowProcessingState) {
        if (this.numberOfRows == 0) {
            return this.position == 0;
        }
        return this.position == this.numberOfRows - 1;
    }

    @Override
    public boolean last(RowProcessingState rowProcessingState) {
        if (this.numberOfRows == 0) {
            this.position = 0;
            return false;
        }
        this.position = this.numberOfRows - 1;
        return true;
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.resolvedMapping;
    }

    @Override
    public Object[] getCurrentRowValuesArray() {
        if (this.position >= this.numberOfRows) {
            return null;
        }
        return this.cachedData[this.position];
    }

    @Override
    public Object getCurrentRowValue(int valueIndex) {
        if (this.position >= this.numberOfRows) {
            return null;
        }
        return this.cachedData[this.position][valueIndex];
    }

    @Override
    public void finishRowProcessing(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUp(SharedSessionContractImplementor session) {
        this.cachedData = null;
    }

    @Override
    public void setFetchSize(int fetchSize) {
    }
}

