/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.internal.AbstractBatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class BatchInitializeEntitySelectFetchInitializer
extends AbstractBatchEntitySelectFetchInitializer {
    private final Set<EntityKey> toBatchLoad = new HashSet<EntityKey>();

    public BatchInitializeEntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> identifierAssembler) {
        super(parentAccess, referencedModelPart, fetchedNavigable, concreteDescriptor, identifierAssembler);
    }

    @Override
    protected void registerResolutionListener() {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.state == AbstractBatchEntitySelectFetchInitializer.State.INITIALIZED) {
            return;
        }
        this.resolveKey(rowProcessingState, this.referencedModelPart, this.parentAccess);
        if (this.entityKey == null) {
            return;
        }
        this.state = AbstractBatchEntitySelectFetchInitializer.State.INITIALIZED;
        this.initializedEntityInstance = this.getExistingInitializedInstance(rowProcessingState);
        if (this.initializedEntityInstance == null) {
            this.registerToBatchFetchQueue(rowProcessingState);
            this.initializedEntityInstance = rowProcessingState.getSession().internalLoad(this.entityKey.getEntityName(), this.entityKey.getIdentifier(), false, false);
            this.toBatchLoad.add(this.entityKey);
        }
    }

    @Override
    public boolean isEntityInitialized() {
        return this.state == AbstractBatchEntitySelectFetchInitializer.State.INITIALIZED;
    }

    @Override
    public void endLoading(ExecutionContext context) {
        SharedSessionContractImplementor session = context.getSession();
        for (EntityKey key : this.toBatchLoad) {
            BatchInitializeEntitySelectFetchInitializer.loadInstance(key, this.referencedModelPart, session);
        }
        this.toBatchLoad.clear();
    }

    public String toString() {
        return "BatchInitializeEntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

