/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.AccessType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.EnhancedSetterImpl;
import org.hibernate.property.access.spi.EnhancedSetterMethodImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessBuildingException;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class PropertyAccessEnhancedImpl
implements PropertyAccess {
    private final PropertyAccessStrategy strategy;
    private final Getter getter;
    private final Setter setter;

    public PropertyAccessEnhancedImpl(PropertyAccessStrategy strategy, Class<?> containerJavaType, String propertyName, AccessType getterAccessType) {
        this.strategy = strategy;
        AccessType propertyAccessType = this.resolveAccessType(getterAccessType, containerJavaType, propertyName);
        switch (propertyAccessType) {
            case FIELD: {
                Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
                if (field == null) {
                    throw new PropertyAccessBuildingException("Could not locate field for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                this.getter = new GetterFieldImpl(containerJavaType, propertyName, field);
                this.setter = new EnhancedSetterImpl(containerJavaType, propertyName, field);
                break;
            }
            case PROPERTY: {
                Method getterMethod = ReflectHelper.getterMethodOrNull(containerJavaType, propertyName);
                if (getterMethod == null) {
                    throw new PropertyAccessBuildingException("Could not locate getter for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                Method setterMethod = ReflectHelper.findSetterMethod(containerJavaType, propertyName, getterMethod.getReturnType());
                this.getter = new GetterMethodImpl(containerJavaType, propertyName, getterMethod);
                this.setter = new EnhancedSetterMethodImpl(containerJavaType, propertyName, setterMethod);
                break;
            }
            default: {
                throw new PropertyAccessBuildingException("Invalid access type " + propertyAccessType + " for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
            }
        }
    }

    private AccessType resolveAccessType(AccessType getterAccessType, Class<?> containerJavaType, String propertyName) {
        if (getterAccessType != null) {
            return getterAccessType;
        }
        return AccessStrategyHelper.getAccessType(containerJavaType, propertyName);
    }

    @Override
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public Getter getGetter() {
        return this.getter;
    }

    @Override
    public Setter getSetter() {
        return this.setter;
    }
}

