/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;

public abstract class AbstractNaturalIdMapping
implements NaturalIdMapping {
    private final EntityMappingType declaringType;
    private final boolean mutable;
    private final NaturalIdDataAccess cachesAccess;
    private final NavigableRole role;

    public AbstractNaturalIdMapping(EntityMappingType declaringType, boolean mutable) {
        this.declaringType = declaringType;
        this.mutable = mutable;
        this.cachesAccess = declaringType.getEntityPersister().getNaturalIdCacheAccessStrategy();
        this.role = declaringType.getNavigableRole().append("{natural-id}");
    }

    public EntityMappingType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.role;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public NaturalIdDataAccess getCacheAccess() {
        return this.cachesAccess;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType;
    }
}

