/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.util.function.Function;
import org.hibernate.internal.log.DeprecationLogger;

public class LegacySpecHelper {
    private LegacySpecHelper() {
    }

    public static Object getValue(String specName, String javaeeName, Function<String, ?> valueAccess) {
        return LegacySpecHelper.getValue(specName, javaeeName, valueAccess, null);
    }

    public static Object getValue(String specName, String javaeeName, Function<String, ?> valueAccess, Function<Object, Boolean> valueChecker) {
        Object specValue = valueAccess.apply(specName);
        if (specValue != null && (valueChecker == null || valueChecker.apply(specValue).booleanValue())) {
            return specValue;
        }
        Object javaeeValue = valueAccess.apply(javaeeName);
        if (javaeeValue != null && (valueChecker == null || valueChecker.apply(javaeeValue).booleanValue())) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting(javaeeName, specName);
            return javaeeValue;
        }
        return null;
    }

    public static Integer getInteger(String specName, String javaeeName, Function<String, ?> valueAccess) {
        Object rawValue = LegacySpecHelper.getValue(specName, javaeeName, valueAccess);
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        return Integer.valueOf(rawValue.toString());
    }

    public static Integer getInteger(String specName, String javaeeName, Function<String, ?> valueAccess, Function<Object, Boolean> valueChecker) {
        Object rawValue = LegacySpecHelper.getValue(specName, javaeeName, valueAccess, valueChecker);
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        return Integer.valueOf(rawValue.toString());
    }
}

