/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.postgresql.util.PGobject;

public class PostgreSQLInetJdbcType
implements JdbcType {
    @Override
    public int getJdbcTypeCode() {
        return 1111;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3002;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return null;
    }

    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) {
        int slashIndex;
        String host = string == null ? null : ((slashIndex = string.lastIndexOf(47)) == -1 ? string : string.substring(0, slashIndex));
        return javaType.wrap(host, options);
    }

    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) {
        return javaType.unwrap((String)value, String.class, options);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String stringValue = PostgreSQLInetJdbcType.this.toString(value, this.getJavaType(), options);
                PGobject holder = new PGobject();
                holder.setType("inet");
                holder.setValue(stringValue);
                st.setObject(index, holder);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String stringValue = PostgreSQLInetJdbcType.this.toString(value, this.getJavaType(), options);
                PGobject holder = new PGobject();
                holder.setType("inet");
                holder.setValue(stringValue);
                st.setObject(name, (Object)holder);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getObject(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getObject(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getObject(name), options);
            }

            private X getObject(Object object, WrapperOptions options) throws SQLException {
                if (object == null) {
                    return null;
                }
                return PostgreSQLInetJdbcType.this.fromString(object.toString(), this.getJavaType(), options);
            }
        };
    }
}

