/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryParameterBindings;

public class QueryKey
implements Serializable {
    private final String sqlQueryString;
    private final ParameterBindingsMemento parameterBindingsMemento;
    private final Integer firstRow;
    private final Integer maxRows;
    private final String tenantIdentifier;
    private final String[] enabledFilterNames;
    private transient int hashCode;

    public static QueryKey from(String sqlQueryString, Limit limit, QueryParameterBindings parameterBindings, SharedSessionContractImplementor persistenceContext) {
        Limit limitToUse = limit == null ? Limit.NONE : limit;
        return new QueryKey(sqlQueryString, parameterBindings.generateQueryKeyMemento(persistenceContext), limitToUse.getFirstRow(), limitToUse.getMaxRows(), persistenceContext.getTenantIdentifier(), persistenceContext.getLoadQueryInfluencers().getEnabledFilterNames());
    }

    public QueryKey(String sql, ParameterBindingsMemento parameterBindingsMemento, Integer firstRow, Integer maxRows, String tenantIdentifier, Set<String> enabledFilterNames) {
        this.sqlQueryString = sql;
        this.parameterBindingsMemento = parameterBindingsMemento;
        this.firstRow = firstRow;
        this.maxRows = maxRows;
        this.tenantIdentifier = tenantIdentifier;
        this.enabledFilterNames = (String[])enabledFilterNames.toArray(String[]::new);
        this.hashCode = this.generateHashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.hashCode = this.generateHashCode();
    }

    private int generateHashCode() {
        int result = 13;
        result = 37 * result + this.sqlQueryString.hashCode();
        result = 37 * result + (this.tenantIdentifier == null ? 0 : this.tenantIdentifier.hashCode());
        result = 37 * result + this.parameterBindingsMemento.hashCode();
        result = 37 * result + Arrays.hashCode(this.enabledFilterNames);
        return result;
    }

    public boolean equals(Object other) {
        QueryKey that;
        try {
            that = (QueryKey)other;
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (!Objects.equals(this.sqlQueryString, that.sqlQueryString)) {
            return false;
        }
        if (!Objects.equals(this.tenantIdentifier, that.tenantIdentifier)) {
            return false;
        }
        if (!Objects.equals(this.firstRow, that.firstRow) || !Objects.equals(this.maxRows, that.maxRows)) {
            return false;
        }
        if (!Objects.equals(this.parameterBindingsMemento, that.parameterBindingsMemento)) {
            return false;
        }
        return Arrays.equals(this.enabledFilterNames, that.enabledFilterNames);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static interface ParameterBindingsMemento
    extends Serializable {
    }
}

