/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.authenticator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.authenticator.CoreAuthenticatorImpl;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticatorImpl
extends CoreAuthenticatorImpl
implements Authenticator {
    private AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions;
    private Set<AuthenticatorTransport> transports;

    public AuthenticatorImpl(@NonNull AttestedCredentialData attestedCredentialData, @Nullable AttestationStatement attestationStatement, long counter, @Nullable Set<AuthenticatorTransport> transports, @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, @Nullable AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions) {
        super(attestedCredentialData, attestationStatement, counter, authenticatorExtensions);
        this.clientExtensions = clientExtensions;
        this.transports = transports;
    }

    public AuthenticatorImpl(@NonNull AttestedCredentialData attestedCredentialData, @Nullable AttestationStatement attestationStatement, long counter, @Nullable Set<AuthenticatorTransport> transports) {
        this(attestedCredentialData, attestationStatement, counter, transports, new AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput>(), new AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput>());
    }

    public AuthenticatorImpl(@NonNull AttestedCredentialData attestedCredentialData, @Nullable AttestationStatement attestationStatement, long counter) {
        this(attestedCredentialData, attestationStatement, counter, Collections.emptySet());
    }

    public static @NonNull AuthenticatorImpl createFromRegistrationData(@NonNull RegistrationData registrationData) {
        AssertUtil.notNull((Object)registrationData, (String)"registrationData must not be null");
        AssertUtil.notNull((Object)registrationData.getAttestationObject(), (String)"attestationObject must not be null");
        AssertUtil.notNull(registrationData.getAttestationObject().getAuthenticatorData(), (String)"authenticatorData must not be null");
        return new AuthenticatorImpl(registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData(), registrationData.getAttestationObject().getAttestationStatement(), registrationData.getAttestationObject().getAuthenticatorData().getSignCount(), registrationData.getTransports());
    }

    @Override
    public @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    public void setClientExtensions(@Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions) {
        this.clientExtensions = clientExtensions;
    }

    @Override
    public @Nullable Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public void setTransports(@Nullable Set<AuthenticatorTransport> transports) {
        this.transports = transports;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticatorImpl that = (AuthenticatorImpl)o;
        return Objects.equals(this.clientExtensions, that.clientExtensions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientExtensions);
    }
}

