/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.util.LoggerUtil;

public class AeshInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshInputStream.class.getName());
    private transient boolean reading;
    private final InputStream consoleStream;
    private static final int BUFFER_SIZE = 1024;
    private final byte[] bBuf = new byte[1024];
    private static final int MINUS_ONE = -1;
    private static final int[] NULL_INPUT = new int[]{-1};

    public AeshInputStream(InputStream consoleStream) {
        this.consoleStream = consoleStream;
        this.reading = true;
    }

    public int[] readAll() {
        if (!this.reading) {
            return new int[]{-1};
        }
        try {
            if (Config.isOSPOSIXCompatible()) {
                String out = this.readFromStream();
                if (out == null) {
                    this.reading = false;
                    return NULL_INPUT;
                }
                int[] input = new int[out.length()];
                for (int i = 0; i < out.length(); ++i) {
                    input[i] = out.charAt(i);
                }
                if (input.length == 1 && input[0] == -1) {
                    this.reading = false;
                }
                return input;
            }
            String out = this.readFromStream();
            if (out == null) {
                this.reading = false;
                return NULL_INPUT;
            }
            if (!(out.isEmpty() || out.charAt(0) != Key.WINDOWS_ESC.getAsChar() && out.charAt(0) != Key.WINDOWS_ESC_2.getAsChar())) {
                int[] input = new int[2];
                if (out.length() == 2) {
                    input[0] = Key.WINDOWS_ESC.getAsChar();
                    input[1] = out.charAt(1);
                } else {
                    input[0] = Key.WINDOWS_ESC.getAsChar();
                    String out2 = this.readFromStream();
                    if (out2 == null) {
                        this.reading = false;
                        return NULL_INPUT;
                    }
                    input[1] = out2.charAt(0);
                }
                return input;
            }
            int[] input = new int[out.length()];
            for (int i = 0; i < out.length(); ++i) {
                input[i] = out.charAt(i);
            }
            return input;
        }
        catch (IOException e) {
            if (this.reading) {
                LOGGER.log(Level.SEVERE, "Reader thread got IO exception while reading: ", e);
            }
            this.reading = false;
            return NULL_INPUT;
        }
        catch (InterruptedException e) {
            if (this.reading) {
                LOGGER.log(Level.SEVERE, "Reader thread got Interrupted while reading: ", e);
            }
            this.reading = false;
            return NULL_INPUT;
        }
    }

    private String readFromStream() throws IOException, InterruptedException {
        while (this.reading) {
            int read = this.consoleStream.read(this.bBuf);
            if (read > 0) {
                return new String(this.bBuf, 0, read);
            }
            if (read >= 0) continue;
            return null;
        }
        return null;
    }

    public void stop() {
        this.reading = false;
    }

    @Override
    public int read() throws IOException {
        return this.consoleStream.read();
    }

    @Override
    public int available() throws IOException {
        return this.consoleStream.available();
    }

    public boolean isReading() {
        return this.reading;
    }
}

