/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.jpa;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.hibernate.orm.PersistenceUnit;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.SynchronizationType;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import liquibase.GlobalConfiguration;
import org.hibernate.internal.SessionFactoryImpl;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.PersistenceExceptionConverter;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public abstract class AbstractJpaConnectionProviderFactory
implements JpaConnectionProviderFactory {
    private final Logger logger = Logger.getLogger(this.getClass());
    protected Config.Scope config;
    protected EntityManagerFactory entityManagerFactory;

    public Connection getConnection() {
        SessionFactoryImpl entityManagerFactory = (SessionFactoryImpl)this.entityManagerFactory.unwrap(SessionFactoryImpl.class);
        try {
            return entityManagerFactory.getJdbcServices().getBootstrapJdbcConnectionAccess().obtainConnection();
        }
        catch (SQLException cause) {
            throw new RuntimeException("Failed to obtain JDBC connection", cause);
        }
    }

    public String getSchema() {
        String schema = Configuration.getRawValue("kc.db-schema");
        if (schema != null && schema.contains("-") && !Boolean.parseBoolean(System.getProperty(GlobalConfiguration.PRESERVE_SCHEMA_CASE.getKey()))) {
            System.setProperty(GlobalConfiguration.PRESERVE_SCHEMA_CASE.getKey(), "true");
            this.logger.warnf("The passed schema '%s' contains a dash. Setting liquibase config option PRESERVE_SCHEMA_CASE to true. See https://github.com/keycloak/keycloak/issues/20870 for more information.", (Object)schema);
        }
        return schema;
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.entityManagerFactory = this.getEntityManagerFactory();
    }

    public void close() {
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
        }
    }

    protected abstract EntityManagerFactory getEntityManagerFactory();

    protected Optional<EntityManagerFactory> getEntityManagerFactory(final String unitName) {
        InjectableInstance instance = Arc.container().select(EntityManagerFactory.class, new Annotation[]{new PersistenceUnit(){

            public Class<? extends Annotation> annotationType() {
                return PersistenceUnit.class;
            }

            public String value() {
                return unitName;
            }
        }});
        if (instance.isResolvable()) {
            return Optional.of((EntityManagerFactory)instance.get());
        }
        return Optional.empty();
    }

    protected EntityManager createEntityManager(EntityManagerFactory emf, KeycloakSession session) {
        EntityManager entityManager = PersistenceExceptionConverter.create((KeycloakSession)session, (EntityManager)emf.createEntityManager(SynchronizationType.SYNCHRONIZED));
        entityManager.setFlushMode(FlushModeType.AUTO);
        return entityManager;
    }
}

