/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.httpcore.BufferAllocator;
import io.undertow.httpcore.ExchangeHandler;
import io.undertow.httpcore.UndertowEngine;
import io.undertow.httpcore.UndertowOption;
import io.undertow.httpcore.UndertowOptionMap;
import io.undertow.httpcore.UndertowOptions;
import io.undertow.server.DefaultExchangeHandler;
import io.undertow.server.HttpHandler;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public final class Undertow {
    private final int ioThreads;
    private final int workerThreads;
    private final List<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
    private volatile List<ListenerInfo> listenerInfo;
    private final HttpHandler rootHandler;
    private final UndertowOptionMap serverOptions;
    private final int bufferSize;
    private final boolean directBuffers;
    private final boolean internalWorker;
    private ExecutorService worker;
    UndertowEngine.EngineInstance engineInstance;

    private Undertow(Builder builder) {
        this.ioThreads = builder.ioThreads;
        this.workerThreads = builder.workerThreads;
        this.listeners.addAll(builder.listeners);
        this.rootHandler = builder.handler;
        this.worker = builder.worker;
        this.bufferSize = builder.bufferSize;
        this.directBuffers = builder.directBuffers;
        this.internalWorker = builder.worker == null;
        this.serverOptions = builder.serverOptions.getMap();
    }

    public static Builder builder() {
        return new Builder();
    }

    public synchronized void start() {
        UndertowLogger.ROOT_LOGGER.debugf("starting undertow server %s", this);
        UndertowEngine engine = ServiceLoader.load(UndertowEngine.class).iterator().next();
        BufferAllocator allocator = new BufferAllocator(){

            public ByteBuf allocateBuffer() {
                return PooledByteBufAllocator.DEFAULT.buffer(Undertow.this.bufferSize);
            }

            public ByteBuf allocateBuffer(boolean direct) {
                if (direct) {
                    return PooledByteBufAllocator.DEFAULT.directBuffer(Undertow.this.bufferSize);
                }
                return PooledByteBufAllocator.DEFAULT.heapBuffer(Undertow.this.bufferSize);
            }

            public ByteBuf allocateBuffer(int bufferSize) {
                return PooledByteBufAllocator.DEFAULT.buffer(bufferSize);
            }

            public ByteBuf allocateBuffer(boolean direct, int bufferSize) {
                if (direct) {
                    return PooledByteBufAllocator.DEFAULT.directBuffer(bufferSize);
                }
                return PooledByteBufAllocator.DEFAULT.heapBuffer(bufferSize);
            }

            public int getBufferSize() {
                return Undertow.this.bufferSize;
            }
        };
        try {
            if (this.internalWorker) {
                this.worker = Executors.newFixedThreadPool(this.workerThreads);
            }
            this.engineInstance = engine.start(this.ioThreads, (Executor)this.worker, allocator);
            DefaultExchangeHandler handler = new DefaultExchangeHandler(this.rootHandler);
            this.listenerInfo = new ArrayList<ListenerInfo>();
            for (ListenerConfig listener : this.listeners) {
                UndertowLogger.ROOT_LOGGER.debugf("Configuring listener with getProtocol %s for interface %s and port %s", (Object)listener.type, listener.host, listener.port);
                if (listener.type == ListenerType.HTTP) {
                    engine.bindHttp(this.engineInstance, (ExchangeHandler)handler, listener.port, listener.host, listener.options);
                    continue;
                }
                if (listener.type != ListenerType.HTTPS) continue;
                engine.bindHttps(this.engineInstance, (ExchangeHandler)handler, listener.port, listener.host, listener.keyStore, listener.keyStorePassword, listener.trustStore, listener.trustStorePassword, listener.options);
            }
        }
        catch (Exception e) {
            if (this.internalWorker && this.worker != null) {
                this.worker.shutdownNow();
            }
            throw new RuntimeException(e);
        }
    }

    public synchronized void stop() {
        UndertowLogger.ROOT_LOGGER.debugf("stopping undertow server %s", this);
        if (this.engineInstance == null) {
            return;
        }
        this.engineInstance.close();
        this.engineInstance = null;
        if (this.internalWorker && this.worker != null) {
            Integer shutdownTimeoutMillis = (Integer)this.serverOptions.get(UndertowOptions.SHUTDOWN_TIMEOUT);
            this.worker.shutdown();
            try {
                if (shutdownTimeoutMillis != null && !this.worker.awaitTermination(shutdownTimeoutMillis.intValue(), TimeUnit.MILLISECONDS)) {
                    this.worker.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.worker.shutdownNow();
                throw new RuntimeException(e);
            }
            this.worker = null;
        }
        this.listenerInfo = null;
    }

    public ExecutorService getWorker() {
        return this.worker;
    }

    public List<ListenerInfo> getListenerInfo() {
        if (this.listenerInfo == null) {
            throw UndertowMessages.MESSAGES.serverNotStarted();
        }
        return Collections.unmodifiableList(this.listenerInfo);
    }

    public static final class Builder {
        int bufferSize;
        int ioThreads;
        int workerThreads;
        boolean directBuffers;
        final List<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
        HttpHandler handler;
        ExecutorService worker;
        final UndertowOptionMap.Builder serverOptions = UndertowOptionMap.builder();

        private Builder() {
            this.ioThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
            this.workerThreads = this.ioThreads * 8;
            long maxMemory = Runtime.getRuntime().maxMemory();
            if (maxMemory < 0x4000000L) {
                this.directBuffers = false;
                this.bufferSize = 512;
            } else if (maxMemory < 0x8000000L) {
                this.directBuffers = true;
                this.bufferSize = 1024;
            } else {
                this.directBuffers = true;
                this.bufferSize = 16364;
            }
        }

        public Undertow build() {
            return new Undertow(this);
        }

        public Builder addListener(ListenerBuilder listenerBuilder) {
            this.listeners.add(new ListenerConfig(listenerBuilder));
            return this;
        }

        public Builder addHttpListener(int port, String host) {
            this.listeners.add(new ListenerConfig(new ListenerBuilder().setType(ListenerType.HTTP).setHost(host).setPort(port)));
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setIoThreads(int ioThreads) {
            this.ioThreads = ioThreads;
            return this;
        }

        public Builder setWorkerThreads(int workerThreads) {
            this.workerThreads = workerThreads;
            return this;
        }

        public Builder setDirectBuffers(boolean directBuffers) {
            this.directBuffers = directBuffers;
            return this;
        }

        public Builder setHandler(HttpHandler handler) {
            this.handler = handler;
            return this;
        }

        public <T> Builder setServerOption(UndertowOption<T> option, T value) {
            this.serverOptions.set(option, value);
            return this;
        }

        public <T> Builder setWorker(ExecutorService worker) {
            this.worker = worker;
            return this;
        }
    }

    private static class ListenerConfig {
        final ListenerType type;
        final int port;
        final String host;
        final String keyStore;
        final String trustStore;
        final String keyStorePassword;
        final String trustStorePassword;
        final Object options;

        private ListenerConfig(ListenerBuilder listenerBuilder) {
            this.type = listenerBuilder.type;
            this.port = listenerBuilder.port;
            this.host = listenerBuilder.host;
            this.keyStorePassword = listenerBuilder.keyStorePassword;
            this.trustStorePassword = listenerBuilder.trustStorePassword;
            this.trustStore = listenerBuilder.trustStore;
            this.keyStore = listenerBuilder.keyStore;
            this.options = listenerBuilder.options;
        }
    }

    public static enum ListenerType {
        HTTP,
        HTTPS;

    }

    public static class ListenerInfo {
        private final String protcol;
        private final SocketAddress address;

        public ListenerInfo(String protcol, SocketAddress address) {
            this.protcol = protcol;
            this.address = address;
        }

        public String getProtcol() {
            return this.protcol;
        }

        public SocketAddress getAddress() {
            return this.address;
        }

        public SSLContext getSslContext() {
            return null;
        }

        public String toString() {
            return "ListenerInfo{protcol='" + this.protcol + '\'' + ", address=" + this.address + ", sslContext=" + this.getSslContext() + '}';
        }
    }

    public static final class ListenerBuilder {
        ListenerType type;
        int port;
        String host;
        String keyStore;
        String trustStore;
        String keyStorePassword;
        String trustStorePassword;
        Object options;
        HttpHandler rootHandler;

        public ListenerBuilder setType(ListenerType type) {
            this.type = type;
            return this;
        }

        public ListenerBuilder setPort(int port) {
            this.port = port;
            return this;
        }

        public ListenerBuilder setHost(String host) {
            this.host = host;
            return this;
        }

        public ListenerBuilder setRootHandler(HttpHandler rootHandler) {
            this.rootHandler = rootHandler;
            return this;
        }

        public ListenerType getType() {
            return this.type;
        }

        public int getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }

        public String getKeyStore() {
            return this.keyStore;
        }

        public ListenerBuilder setKeyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public String getTrustStore() {
            return this.trustStore;
        }

        public ListenerBuilder setTrustStore(String trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public ListenerBuilder setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public ListenerBuilder setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Object getOptions() {
            return this.options;
        }

        public ListenerBuilder setOptions(Object options) {
            this.options = options;
            return this;
        }

        public HttpHandler getRootHandler() {
            return this.rootHandler;
        }
    }
}

