/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.deployment.dev.testing.TestResult;
import java.util.ArrayList;
import java.util.List;

public class TestClassResult
implements Comparable<TestClassResult> {
    final String className;
    final List<TestResult> passing;
    final List<TestResult> failing;
    final List<TestResult> skipped;
    final long latestRunId;
    final long time;

    public TestClassResult(String className, List<TestResult> passing, List<TestResult> failing, List<TestResult> skipped, long time) {
        this.className = className;
        this.passing = passing;
        this.failing = failing;
        this.skipped = skipped;
        this.time = time;
        long runId = 0L;
        for (TestResult i : passing) {
            runId = Math.max(i.runId, runId);
        }
        for (TestResult i : failing) {
            runId = Math.max(i.runId, runId);
        }
        this.latestRunId = runId;
    }

    public String getClassName() {
        return this.className;
    }

    public List<TestResult> getPassing() {
        return this.passing;
    }

    public List<TestResult> getFailing() {
        return this.failing;
    }

    public List<TestResult> getSkipped() {
        return this.skipped;
    }

    public long getLatestRunId() {
        return this.latestRunId;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public int compareTo(TestClassResult o) {
        return this.className.compareTo(o.className);
    }

    public List<TestResult> getResults() {
        ArrayList<TestResult> ret = new ArrayList<TestResult>();
        ret.addAll(this.passing);
        ret.addAll(this.failing);
        ret.addAll(this.skipped);
        return ret;
    }
}

