/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import jakarta.ws.rs.core.MediaType;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.LoggableFailure;

public class WeightedMediaType
extends MediaType
implements Comparable<WeightedMediaType> {
    private float weight = 1.0f;

    private WeightedMediaType(String type, String subtype, Map<String, String> parameters) {
        super(type, subtype, parameters);
    }

    public float getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(WeightedMediaType o) {
        WeightedMediaType type2 = this;
        WeightedMediaType type1 = o;
        if (type1.weight < type2.weight) {
            return -1;
        }
        if (type1.weight > type2.weight) {
            return 1;
        }
        if (type1.isWildcardType() && !type2.isWildcardType()) {
            return -1;
        }
        if (!type1.isWildcardType() && type2.isWildcardType()) {
            return 1;
        }
        if (type1.isWildcardSubtype() && !type2.isWildcardSubtype()) {
            return -1;
        }
        if (!type1.isWildcardSubtype() && type2.isWildcardSubtype()) {
            return 1;
        }
        int numNonQ = 0;
        if (type1.getParameters() != null) {
            numNonQ = type1.getParameters().size();
        }
        int numNonQ2 = 0;
        if (type2.getParameters() != null) {
            numNonQ2 = type2.getParameters().size();
        }
        if (numNonQ < numNonQ2) {
            return -1;
        }
        if (numNonQ > numNonQ2) {
            return 1;
        }
        return 0;
    }

    public boolean isCompatible(MediaType other) {
        if (other == null) {
            boolean bl = false;
        }
        boolean result = this.getType().equals("*") || other != null && other.getType().equals("*") ? true : (other != null && this.getType().equalsIgnoreCase(other.getType()) && (this.getSubtype().equals("*") || other != null && other.getSubtype().equals("*")) ? true : (other != null && this.getType().equalsIgnoreCase(other.getType()) && this.getSubtype().equalsIgnoreCase(other.getSubtype()) ? (this.getParameters() == null || this.getParameters().size() == 0 ? true : this.equals(other)) : false));
        return result;
    }

    public static WeightedMediaType valueOf(String type) {
        MediaType tmp = MediaTypeHeaderDelegate.parse(type);
        if (tmp.getParameters() == null || !tmp.getParameters().containsKey("q")) {
            return new WeightedMediaType(tmp.getType(), tmp.getSubtype(), tmp.getParameters());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(tmp.getParameters());
        String q = (String)params.remove("q");
        WeightedMediaType mediaType = new WeightedMediaType(tmp.getType(), tmp.getSubtype(), params);
        mediaType.weight = WeightedMediaType.getQWithParamInfo(mediaType, q);
        return mediaType;
    }

    public static WeightedMediaType parse(MediaType tmp) {
        if (tmp.getParameters() == null || !tmp.getParameters().containsKey("q")) {
            return new WeightedMediaType(tmp.getType(), tmp.getSubtype(), tmp.getParameters());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(tmp.getParameters());
        String q = (String)params.remove("q");
        WeightedMediaType mediaType = new WeightedMediaType(tmp.getType(), tmp.getSubtype(), params);
        mediaType.weight = WeightedMediaType.getQWithParamInfo(mediaType, q);
        return mediaType;
    }

    private static float getQWithParamInfo(MediaType type, String val) {
        try {
            if (val != null) {
                float rtn = Float.valueOf(val).floatValue();
                return rtn;
            }
        }
        catch (NumberFormatException e) {
            throw new LoggableFailure(Messages.MESSAGES.mediaTypeQMustBeFloat(type), 400);
        }
        return 1.0f;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

