/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.Experimental;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;
import org.infinispan.functional.impl.MetaParams;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1003)
@Experimental
public final class MetaParamsInternalMetadata
implements InternalMetadata,
MetaParam.Lookup {
    private static final MetaParamsInternalMetadata EMPTY = new MetaParamsInternalMetadata(MetaParams.empty());
    final MetaParams params;

    public static Metadata from(MetaParams params) {
        return new MetaParamsInternalMetadata(params);
    }

    @ProtoFactory
    MetaParamsInternalMetadata(NumericVersion numericVersion, SimpleClusteredVersion clusteredVersion, long created, long lastUsed, long lifespan, long maxIdle, CounterConfiguration counterConfiguration, boolean updateCreationTimestamp) {
        this.params = new MetaParams(MetaParams.EMPTY_ARRAY, 0);
        if (numericVersion != null || clusteredVersion != null) {
            this.params.add(new MetaParam.MetaEntryVersion(numericVersion == null ? clusteredVersion : numericVersion));
        }
        if (created > -1L) {
            this.params.add(new MetaParam.MetaCreated(created));
        }
        if (lastUsed > -1L) {
            this.params.add(new MetaParam.MetaLastUsed(lastUsed));
        }
        if (lifespan > -1L) {
            this.params.add(new MetaParam.MetaLifespan(lifespan));
        }
        if (maxIdle > -1L) {
            this.params.add(new MetaParam.MetaMaxIdle(maxIdle));
        }
        if (counterConfiguration != null) {
            this.params.add(new CounterConfigurationMetaParam(counterConfiguration));
        }
        this.params.add(MetaParam.MetaUpdateCreationTime.of(updateCreationTimestamp));
    }

    private MetaParamsInternalMetadata(MetaParams params) {
        this.params = params;
    }

    @ProtoField(value=1)
    NumericVersion getNumericVersion() {
        EntryVersion version = this.version();
        return version instanceof NumericVersion ? (NumericVersion)version : null;
    }

    @ProtoField(value=2)
    SimpleClusteredVersion getClusteredVersion() {
        EntryVersion version = this.version();
        return version instanceof SimpleClusteredVersion ? (SimpleClusteredVersion)version : null;
    }

    @Override
    @ProtoField(number=3, defaultValue="-1")
    public long created() {
        return this.params.find(MetaParam.MetaCreated.class).map(MetaParam.MetaLong::get).orElse(0L);
    }

    @Override
    @ProtoField(number=4, defaultValue="-1")
    public long lastUsed() {
        return this.params.find(MetaParam.MetaLastUsed.class).map(MetaParam.MetaLong::get).orElse(0L);
    }

    @Override
    public boolean isExpired(long now) {
        long expiryTime = this.expiryTime();
        return expiryTime >= 0L && expiryTime <= now;
    }

    @Override
    public long expiryTime() {
        long maxIdle;
        long deadline = -1L;
        long lifespan = this.lifespan();
        if (lifespan >= 0L) {
            deadline = this.created() + lifespan;
        }
        if ((maxIdle = this.maxIdle()) >= 0L) {
            deadline = deadline < 0L ? this.lastUsed() + maxIdle : Math.min(deadline, this.lastUsed() + maxIdle);
        }
        return deadline;
    }

    @Override
    @ProtoField(number=5, defaultValue="-1")
    public long lifespan() {
        return this.params.find(MetaParam.MetaLifespan.class).orElse(MetaParam.MetaLifespan.defaultValue()).get();
    }

    @Override
    @ProtoField(number=6, defaultValue="-1")
    public long maxIdle() {
        return this.params.find(MetaParam.MetaMaxIdle.class).orElse(MetaParam.MetaMaxIdle.defaultValue()).get();
    }

    @ProtoField(value=7)
    public CounterConfiguration counterConfiguration() {
        return this.params.find(CounterConfigurationMetaParam.class).map(CounterConfigurationMetaParam::get).orElse(null);
    }

    @Override
    @ProtoField(value=8, defaultValue="true")
    public boolean updateCreationTimestamp() {
        return this.params.find(MetaParam.MetaUpdateCreationTime.class).map(MetaParam.MetaBoolean::get).orElse(true);
    }

    @Override
    public EntryVersion version() {
        return this.params.find(MetaParam.MetaEntryVersion.class).map(MetaParam.MetaEntryVersion::get).orElse(null);
    }

    @Override
    public Builder builder() {
        return new Builder(this.params.copy());
    }

    @Override
    public <T extends MetaParam> Optional<T> findMetaParam(Class<T> type) {
        return this.params.find(type);
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public String toString() {
        return "MetaParamsInternalMetadata{params=" + String.valueOf(this.params) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaParamsInternalMetadata that = (MetaParamsInternalMetadata)o;
        return this.created() == that.created() && this.lastUsed() == that.lastUsed() && this.lifespan() == that.lifespan() && this.maxIdle() == that.maxIdle() && Objects.equals(this.version(), that.version()) && Objects.equals(this.counterConfiguration(), that.counterConfiguration());
    }

    public int hashCode() {
        return Objects.hash(this.created(), this.lastUsed(), this.lastUsed(), this.maxIdle(), this.version(), this.counterConfiguration());
    }

    public static Builder getBuilder(MetaParamsInternalMetadata metadata) {
        return metadata == null ? new Builder() : metadata.builder();
    }

    public static MetaParamsInternalMetadata empty() {
        return EMPTY;
    }

    public static class Builder
    implements Metadata.Builder {
        private final MetaParams params;

        public Builder() {
            this.params = MetaParams.empty();
        }

        Builder(MetaParams params) {
            this.params = params;
        }

        @Override
        public Builder lifespan(long time, TimeUnit unit) {
            this.params.add(new MetaParam.MetaLifespan(unit.toMillis(time)));
            return this;
        }

        @Override
        public Builder lifespan(long time) {
            this.params.add(new MetaParam.MetaLifespan(time));
            return this;
        }

        @Override
        public Builder maxIdle(long time, TimeUnit unit) {
            this.params.add(new MetaParam.MetaMaxIdle(unit.toMillis(time)));
            return this;
        }

        @Override
        public Builder maxIdle(long time) {
            this.params.add(new MetaParam.MetaMaxIdle(time));
            return this;
        }

        @Override
        public Builder version(EntryVersion version) {
            this.params.add(new MetaParam.MetaEntryVersion(version));
            return this;
        }

        @Override
        public Metadata.Builder updateCreationTimestamp(boolean enabled) {
            this.params.add(new MetaParam.MetaUpdateCreationTime(enabled));
            return this;
        }

        @Override
        public MetaParamsInternalMetadata build() {
            return new MetaParamsInternalMetadata(this.params);
        }

        public Builder add(MetaParam<?> metaParam) {
            this.params.add(metaParam);
            return this;
        }

        @Override
        public Builder merge(Metadata metadata) {
            if (metadata instanceof MetaParamsInternalMetadata) {
                this.params.merge(((MetaParamsInternalMetadata)metadata).params);
            } else {
                if (!this.params.find(MetaParam.MetaLifespan.class).isPresent()) {
                    this.lifespan(metadata.lifespan());
                }
                if (!this.params.find(MetaParam.MetaMaxIdle.class).isPresent()) {
                    this.maxIdle(metadata.maxIdle());
                }
                if (!this.params.find(MetaParam.MetaEntryVersion.class).isPresent()) {
                    this.version(metadata.version());
                }
                if (!this.params.find(MetaParam.MetaUpdateCreationTime.class).isPresent()) {
                    this.updateCreationTimestamp(metadata.updateCreationTimestamp());
                }
            }
            return this;
        }
    }
}

