/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j.util;

public class SctpParser {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String bytesToHex(byte[] bytes, int off, int len) {
        char[] hexChars = new char[len * 2];
        int hexCharsIndex = 0;
        for (int j = off; j < off + len; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[hexCharsIndex] = hexArray[v >>> 4];
            hexChars[hexCharsIndex + 1] = hexArray[v & 0xF];
            hexCharsIndex += 2;
        }
        return new String(hexChars);
    }

    public static void debugSctpPacket(byte[] packet, String id) {
        System.out.println(id);
        if (packet.length >= 12) {
            int srcPort = SctpParser.bytes_to_short(packet, 0);
            int dstPort = SctpParser.bytes_to_short(packet, 2);
            long verificationTag = SctpParser.bytes_to_long(packet, 4);
            long checksum = SctpParser.bytes_to_long(packet, 8);
            System.out.println("SRC P: " + srcPort + " DST P: " + dstPort + " VTAG: 0x" + Long.toHexString(verificationTag) + " CHK: 0x" + Long.toHexString(checksum));
            SctpParser.debugChunks(packet);
        }
    }

    private static long bytes_to_long(byte[] buffer, int offset) {
        int fByte = 0xFF & buffer[offset];
        int sByte = 0xFF & buffer[offset + 1];
        int tByte = 0xFF & buffer[offset + 2];
        int foByte = 0xFF & buffer[offset + 3];
        return (long)(fByte << 24 | sByte << 16 | tByte << 8 | foByte) & 0xFFFFFFFFL;
    }

    private static int bytes_to_short(byte[] buffer, int offset) {
        int fByte = 0xFF & buffer[offset];
        int sByte = 0xFF & buffer[offset + 1];
        return (fByte << 8 | sByte) & 0xFFFF;
    }

    private static void debugChunks(byte[] packet) {
        int offset = 12;
        while (packet.length - offset >= 4) {
            System.out.println("Packet data length: " + (packet.length - 12) + ", current offset = " + offset);
            int chunkType = packet[offset++] & 0xFF;
            int chunkFlags = packet[offset++] & 0xFF;
            int chunkLength = SctpParser.bytes_to_short(packet, offset);
            System.out.println("Chunk length: " + chunkLength);
            if (chunkLength < 4) {
                System.out.println("Empty chunk");
                return;
            }
            offset += 2;
            System.out.println("Chunk type: " + chunkType + " Chunk flags: " + chunkFlags + " Chunk length: " + chunkLength);
            if (chunkType == 1) {
                System.out.println("Chunk type init");
                long initTag = SctpParser.bytes_to_long(packet, offset);
                long a_rwnd = SctpParser.bytes_to_long(packet, offset += 4);
                int nOutStream = SctpParser.bytes_to_short(packet, offset += 4);
                int nInStream = SctpParser.bytes_to_short(packet, offset += 2);
                long initTSN = SctpParser.bytes_to_long(packet, offset += 2);
                offset += 4;
                System.out.println("ITAG: 0x" + Long.toHexString(initTag) + " a_rwnd: " + a_rwnd + " nOutStream: " + nOutStream + " nInStream: " + nInStream + " initTSN: 0x" + Long.toHexString(initTSN));
                while (offset < chunkLength) {
                    int type2 = SctpParser.bytes_to_short(packet, offset);
                    int length = SctpParser.bytes_to_short(packet, offset += 2);
                    offset += 2;
                    System.out.println("T: " + type2 + " L: " + length + " left: " + (chunkLength - (offset += length - 4)));
                }
                offset += chunkLength - 4 - 16;
                continue;
            }
            if (chunkType == 0) {
                System.out.println("Chunk type payload data");
                boolean U = (chunkFlags & 4) > 0;
                boolean B = (chunkFlags & 2) > 0;
                boolean E = (chunkFlags & 1) > 0;
                long TSN = SctpParser.bytes_to_long(packet, offset);
                int streamIdS = SctpParser.bytes_to_short(packet, offset += 4);
                int streamSeq = SctpParser.bytes_to_short(packet, offset += 2);
                long PPID = SctpParser.bytes_to_long(packet, offset += 2);
                offset += 4;
                System.out.println("U: " + U + " B: " + B + " E: " + E + " TSN: 0x" + Long.toHexString(TSN) + " SID: 0x" + Integer.toHexString(streamIdS) + " SSEQ: 0x" + Integer.toHexString(streamSeq) + " PPID: 0x" + Long.toHexString(PPID));
                offset += chunkLength - 4 - 12;
                continue;
            }
            if (chunkType == 6) {
                System.out.println("We have abort!!!");
                if (offset >= chunkLength) {
                    System.out.println("No abort CAUSE!!!");
                }
                while (offset < chunkLength) {
                    int causeCode = SctpParser.bytes_to_short(packet, offset);
                    int causeLength = SctpParser.bytes_to_short(packet, offset += 2);
                    offset += 2;
                    System.out.println("Cause: " + causeCode + " L: " + causeLength);
                }
                continue;
            }
            offset += chunkLength - 4;
        }
    }
}

