/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transport.dtls;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.DtlsClient;
import org.jitsi.nlj.dtls.DtlsServer;
import org.jitsi.nlj.dtls.DtlsStack;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.transport.dtls.DtlsTransport;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004+,-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u001a\u0010#\u001a\u00020\u00172\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%J\u0010\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010&J\u0006\u0010)\u001a\u00020\u0017J\u0006\u0010*\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/utils/logging2/Logger;)V", "dtlsHandshakeComplete", "", "dtlsStack", "Lorg/jitsi/nlj/dtls/DtlsStack;", "eventHandler", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$EventHandler;", "incomingDataHandler", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$IncomingDataHandler;", "isConnected", "()Z", "logger", "outgoingDataHandler", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$OutgoingDataHandler;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stats", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$Stats;", "describe", "", "iceUdpTransportPe", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "dtlsDataReceived", "data", "", "off", "", "len", "getDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "sendDtlsData", "setRemoteFingerprints", "remoteFingerprints", "", "", "setSetupAttribute", "setupAttr", "startDtlsHandshake", "stop", "EventHandler", "IncomingDataHandler", "OutgoingDataHandler", "Stats", "jitsi-videobridge"})
public final class DtlsTransport {
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean running;
    @JvmField
    @Nullable
    public IncomingDataHandler incomingDataHandler;
    @JvmField
    @Nullable
    public OutgoingDataHandler outgoingDataHandler;
    @JvmField
    @Nullable
    public EventHandler eventHandler;
    private boolean dtlsHandshakeComplete;
    @NotNull
    private final Stats stats;
    @NotNull
    private final DtlsStack dtlsStack;

    /*
     * WARNING - void declaration
     */
    public DtlsTransport(@NotNull Logger parentLogger) {
        void it;
        DtlsStack dtlsStack2;
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.running = new AtomicBoolean(true);
        this.stats = new Stats(0, 0, 0, 0, 15, null);
        DtlsStack dtlsStack3 = dtlsStack2 = new DtlsStack(this.logger);
        DtlsTransport dtlsTransport = this;
        boolean bl = false;
        it.setIncomingDataHandler(new DtlsStack.IncomingDataHandler(this){
            final /* synthetic */ DtlsTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataReceived(@NotNull byte[] data2, int off, int len) {
                Intrinsics.checkNotNullParameter(data2, "data");
                Stats stats = DtlsTransport.access$getStats$p(this.this$0);
                int n = stats.getNumPacketsReceived();
                stats.setNumPacketsReceived(n + 1);
                IncomingDataHandler incomingDataHandler = this.this$0.incomingDataHandler;
                if (incomingDataHandler != null) {
                    incomingDataHandler.dtlsAppDataReceived(data2, off, len);
                } else {
                    dtlsStack.1.1 var6_6 = this;
                    DtlsTransport dtlsTransport = this.this$0;
                    dtlsStack.1.1 $this$dataReceived_u24lambda_u2d0 = var6_6;
                    boolean bl = false;
                    Stats stats2 = DtlsTransport.access$getStats$p(dtlsTransport);
                    int n2 = stats2.getNumIncomingPacketsDroppedNoHandler();
                    stats2.setNumIncomingPacketsDroppedNoHandler(n2 + 1);
                }
            }
        });
        it.setOutgoingDataHandler(new DtlsStack.OutgoingDataHandler(this){
            final /* synthetic */ DtlsTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendData(@NotNull byte[] data2, int off, int len) {
                Intrinsics.checkNotNullParameter(data2, "data");
                OutgoingDataHandler outgoingDataHandler = this.this$0.outgoingDataHandler;
                if (outgoingDataHandler != null) {
                    outgoingDataHandler.sendData(data2, off, len);
                    Unit unit = Unit.INSTANCE;
                    DtlsTransport dtlsTransport = this.this$0;
                    Unit it = unit;
                    boolean bl = false;
                    Stats stats = DtlsTransport.access$getStats$p(dtlsTransport);
                    int n = stats.getNumPacketsSent();
                    stats.setNumPacketsSent(n + 1);
                } else {
                    dtlsStack.1.2 var4_5 = this;
                    DtlsTransport dtlsTransport = this.this$0;
                    dtlsStack.1.2 $this$sendData_u24lambda_u2d1 = var4_5;
                    boolean bl = false;
                    Stats stats = DtlsTransport.access$getStats$p(dtlsTransport);
                    int n = stats.getNumOutgoingPacketsDroppedNoHandler();
                    stats.setNumOutgoingPacketsDroppedNoHandler(n + 1);
                }
            }
        });
        it.setEventHandler(new DtlsStack.EventHandler(this){
            final /* synthetic */ DtlsTransport this$0;
            {
                this.this$0 = $receiver;
            }

            public void handshakeComplete(int chosenSrtpProtectionProfile, @NotNull TlsRole tlsRole, @NotNull byte[] keyingMaterial) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)tlsRole), "tlsRole");
                    Intrinsics.checkNotNullParameter(keyingMaterial, "keyingMaterial");
                    DtlsTransport.access$setDtlsHandshakeComplete$p(this.this$0, true);
                    EventHandler eventHandler = this.this$0.eventHandler;
                    if (eventHandler == null) break block0;
                    eventHandler.handshakeComplete(chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
                }
            }
        });
        dtlsTransport.dtlsStack = dtlsStack2;
    }

    public final boolean isConnected() {
        return this.dtlsHandshakeComplete;
    }

    public final void startDtlsHandshake() {
        this.logger.info("Starting DTLS handshake, role=" + this.dtlsStack.getRole());
        if (this.dtlsStack.getRole() == null) {
            this.logger.warn("Starting the DTLS stack before it knows its role");
        }
        try {
            this.dtlsStack.start();
        }
        catch (Throwable t) {
            this.logger.error("Error during DTLS negotiation, closing this transport manager", t);
        }
    }

    public final void setSetupAttribute(@Nullable String setupAttr) {
        CharSequence charSequence = setupAttr;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        String string = setupAttr.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        charSequence = string;
        if (Intrinsics.areEqual(charSequence, "active")) {
            this.logger.info("The remote side is acting as DTLS client, we'll act as server");
            this.dtlsStack.actAsServer();
        } else if (Intrinsics.areEqual(charSequence, "passive")) {
            this.logger.info("The remote side is acting as DTLS server, we'll act as client");
            this.dtlsStack.actAsClient();
        } else {
            this.logger.error("The remote side sent an unrecognized DTLS setup value: " + setupAttr);
        }
    }

    public final void setRemoteFingerprints(@NotNull Map<String, String> remoteFingerprints) {
        Intrinsics.checkNotNullParameter(remoteFingerprints, "remoteFingerprints");
        if (remoteFingerprints.isEmpty()) {
            return;
        }
        this.dtlsStack.setRemoteFingerprints(remoteFingerprints);
    }

    public final void describe(@NotNull IceUdpTransportPacketExtension iceUdpTransportPe) {
        String string;
        DtlsFingerprintPacketExtension dtlsFingerprintPacketExtension;
        Intrinsics.checkNotNullParameter(iceUdpTransportPe, "iceUdpTransportPe");
        Object object = iceUdpTransportPe.getFirstChildOfType(DtlsFingerprintPacketExtension.class);
        if (object == null) {
            DtlsFingerprintPacketExtension dtlsFingerprintPacketExtension2;
            DtlsTransport $this$describe_u24lambda_u2d2 = this;
            boolean bl = false;
            DtlsFingerprintPacketExtension it = dtlsFingerprintPacketExtension2 = new DtlsFingerprintPacketExtension();
            boolean bl2 = false;
            iceUdpTransportPe.addChildExtension(it);
            dtlsFingerprintPacketExtension = dtlsFingerprintPacketExtension2;
        } else {
            dtlsFingerprintPacketExtension = object;
        }
        DtlsFingerprintPacketExtension fingerprintPE = dtlsFingerprintPacketExtension;
        object = this.dtlsStack.getRole();
        if (object instanceof DtlsServer) {
            string = "passive";
        } else if (object instanceof DtlsClient) {
            string = "active";
        } else if (object == null) {
            string = "actpass";
        } else {
            throw new IllegalStateException("Cannot describe role " + this.dtlsStack.getRole());
        }
        fingerprintPE.setSetup(string);
        fingerprintPE.setFingerprint(this.dtlsStack.getLocalFingerprint());
        fingerprintPE.setHash(this.dtlsStack.getLocalFingerprintHashFunction());
    }

    public final void dtlsDataReceived(@NotNull byte[] data2, int off, int len) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.dtlsStack.processIncomingProtocolData(data2, off, len);
    }

    public final void sendDtlsData(@NotNull byte[] data2, int off, int len) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.dtlsStack.sendApplicationData(data2, off, len);
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.logger.info("Stopping");
            this.dtlsStack.close();
        }
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2d3 = orderedJsonObject = this.stats.toJson();
        boolean bl = false;
        $this$getDebugState_u24lambda_u2d3.put("running", (Object)this.running.get());
        $this$getDebugState_u24lambda_u2d3.put("role", String.valueOf(this.dtlsStack.getRole()));
        $this$getDebugState_u24lambda_u2d3.put("is_connected", (Object)this.isConnected());
        return orderedJsonObject;
    }

    public static final /* synthetic */ Stats access$getStats$p(DtlsTransport $this) {
        return $this.stats;
    }

    public static final /* synthetic */ void access$setDtlsHandshakeComplete$p(DtlsTransport $this, boolean bl) {
        $this.dtlsHandshakeComplete = bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$Stats;", "", "numPacketsReceived", "", "numIncomingPacketsDroppedNoHandler", "numPacketsSent", "numOutgoingPacketsDroppedNoHandler", "(IIII)V", "getNumIncomingPacketsDroppedNoHandler", "()I", "setNumIncomingPacketsDroppedNoHandler", "(I)V", "getNumOutgoingPacketsDroppedNoHandler", "setNumOutgoingPacketsDroppedNoHandler", "getNumPacketsReceived", "setNumPacketsReceived", "getNumPacketsSent", "setNumPacketsSent", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "toString", "", "jitsi-videobridge"})
    private static final class Stats {
        private int numPacketsReceived;
        private int numIncomingPacketsDroppedNoHandler;
        private int numPacketsSent;
        private int numOutgoingPacketsDroppedNoHandler;

        public Stats(int numPacketsReceived, int numIncomingPacketsDroppedNoHandler, int numPacketsSent, int numOutgoingPacketsDroppedNoHandler) {
            this.numPacketsReceived = numPacketsReceived;
            this.numIncomingPacketsDroppedNoHandler = numIncomingPacketsDroppedNoHandler;
            this.numPacketsSent = numPacketsSent;
            this.numOutgoingPacketsDroppedNoHandler = numOutgoingPacketsDroppedNoHandler;
        }

        public /* synthetic */ Stats(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, n4);
        }

        public final int getNumPacketsReceived() {
            return this.numPacketsReceived;
        }

        public final void setNumPacketsReceived(int n) {
            this.numPacketsReceived = n;
        }

        public final int getNumIncomingPacketsDroppedNoHandler() {
            return this.numIncomingPacketsDroppedNoHandler;
        }

        public final void setNumIncomingPacketsDroppedNoHandler(int n) {
            this.numIncomingPacketsDroppedNoHandler = n;
        }

        public final int getNumPacketsSent() {
            return this.numPacketsSent;
        }

        public final void setNumPacketsSent(int n) {
            this.numPacketsSent = n;
        }

        public final int getNumOutgoingPacketsDroppedNoHandler() {
            return this.numOutgoingPacketsDroppedNoHandler;
        }

        public final void setNumOutgoingPacketsDroppedNoHandler(int n) {
            this.numOutgoingPacketsDroppedNoHandler = n;
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u2d0 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u2d0.put("num_packets_received", (Object)this.numPacketsReceived);
            $this$toJson_u24lambda_u2d0.put("num_incoming_packets_dropped_no_handler", (Object)this.numIncomingPacketsDroppedNoHandler);
            $this$toJson_u24lambda_u2d0.put("num_packets_sent", (Object)this.numPacketsSent);
            $this$toJson_u24lambda_u2d0.put("num_outgoing_packets_dropped_no_handler", (Object)this.numOutgoingPacketsDroppedNoHandler);
            return orderedJsonObject;
        }

        public final int component1() {
            return this.numPacketsReceived;
        }

        public final int component2() {
            return this.numIncomingPacketsDroppedNoHandler;
        }

        public final int component3() {
            return this.numPacketsSent;
        }

        public final int component4() {
            return this.numOutgoingPacketsDroppedNoHandler;
        }

        @NotNull
        public final Stats copy(int numPacketsReceived, int numIncomingPacketsDroppedNoHandler, int numPacketsSent, int numOutgoingPacketsDroppedNoHandler) {
            return new Stats(numPacketsReceived, numIncomingPacketsDroppedNoHandler, numPacketsSent, numOutgoingPacketsDroppedNoHandler);
        }

        public static /* synthetic */ Stats copy$default(Stats stats, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = stats.numPacketsReceived;
            }
            if ((n5 & 2) != 0) {
                n2 = stats.numIncomingPacketsDroppedNoHandler;
            }
            if ((n5 & 4) != 0) {
                n3 = stats.numPacketsSent;
            }
            if ((n5 & 8) != 0) {
                n4 = stats.numOutgoingPacketsDroppedNoHandler;
            }
            return stats.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Stats(numPacketsReceived=" + this.numPacketsReceived + ", numIncomingPacketsDroppedNoHandler=" + this.numIncomingPacketsDroppedNoHandler + ", numPacketsSent=" + this.numPacketsSent + ", numOutgoingPacketsDroppedNoHandler=" + this.numOutgoingPacketsDroppedNoHandler + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.numPacketsReceived);
            result2 = result2 * 31 + Integer.hashCode(this.numIncomingPacketsDroppedNoHandler);
            result2 = result2 * 31 + Integer.hashCode(this.numPacketsSent);
            result2 = result2 * 31 + Integer.hashCode(this.numOutgoingPacketsDroppedNoHandler);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stats)) {
                return false;
            }
            Stats stats = (Stats)other;
            if (this.numPacketsReceived != stats.numPacketsReceived) {
                return false;
            }
            if (this.numIncomingPacketsDroppedNoHandler != stats.numIncomingPacketsDroppedNoHandler) {
                return false;
            }
            if (this.numPacketsSent != stats.numPacketsSent) {
                return false;
            }
            return this.numOutgoingPacketsDroppedNoHandler == stats.numOutgoingPacketsDroppedNoHandler;
        }

        public Stats() {
            this(0, 0, 0, 0, 15, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$OutgoingDataHandler;", "", "sendData", "", "buf", "", "off", "", "len", "jitsi-videobridge"})
    public static interface OutgoingDataHandler {
        public void sendData(@NotNull byte[] var1, int var2, int var3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H&\u00a8\u0006\t"}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$IncomingDataHandler;", "", "dtlsAppDataReceived", "", "buf", "", "off", "", "len", "jitsi-videobridge"})
    public static interface IncomingDataHandler {
        public void dtlsAppDataReceived(@NotNull byte[] var1, int var2, int var3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lorg/jitsi/videobridge/transport/dtls/DtlsTransport$EventHandler;", "", "handshakeComplete", "", "chosenSrtpProtectionProfile", "", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "keyingMaterial", "", "jitsi-videobridge"})
    public static interface EventHandler {
        public void handshakeComplete(int var1, @NotNull TlsRole var2, @NotNull byte[] var3);
    }
}

