/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumentationUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.util.Printer;
import org.jetbrains.coverage.org.objectweb.asm.util.Textifier;
import org.jetbrains.coverage.org.objectweb.asm.util.TraceClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSumCalculator
extends ClassVisitor {
    private final Map<String, byte[]> checksums = new HashMap<String, byte[]>();
    private final MessageDigest messageDigest;
    private final String className;

    /*
     * WARNING - void declaration
     */
    public CheckSumCalculator(int api, String className) {
        super(api, new TraceClassVisitor(null, new ChecksumPrinter(api), null));
        void var2_3;
        this.className = var2_3;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
            return;
        }
        catch (NoSuchAlgorithmException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    public Map<String, byte[]> getChecksums() {
        return this.checksums;
    }

    private Printer getPrinter() {
        return ((TraceClassVisitor)this.cv).p;
    }

    /*
     * WARNING - void declaration
     */
    private void saveChecksum(String name) {
        PrintWriter pw = null;
        try {
            void var3_4;
            void var1_1;
            StringWriter sw = new StringWriter();
            pw = new PrintWriter(sw);
            this.getPrinter().print(pw);
            this.checksums.put((String)var1_1, this.messageDigest.digest(var3_4.toString().getBytes()));
            this.getPrinter().getText().clear();
            pw.close();
            return;
        }
        catch (Throwable throwable) {
            this.getPrinter().getText().clear();
            if (pw != null) {
                void var2_3;
                var2_3.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.checksums.containsKey(this.className)) {
            CheckSumCalculator checkSumCalculator = this;
            checkSumCalculator.saveChecksum(checkSumCalculator.className);
        }
        CheckSumCalculator checkSumCalculator = this;
        return new MethodVisitor(checkSumCalculator, checkSumCalculator.api, super.visitMethod((int)var1_1, name, desc, signature, exceptions), (String)var2_2, (String)var3_3){
            final /* synthetic */ String val$name;
            final /* synthetic */ String val$desc;
            final /* synthetic */ CheckSumCalculator this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$name = string;
                this.val$desc = string2;
                super((int)var2_2, (MethodVisitor)var3_3);
            }

            public void visitEnd() {
                super.visitEnd();
                CheckSumCalculator.access$000(this.this$0, TestDiscoveryInstrumentationUtils.getMethodId(this.val$name, this.val$desc));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(CheckSumCalculator x0, String x1) {
        void var1_1;
        x0.saveChecksum((String)var1_1);
    }

    private static class ChecksumPrinter
    extends Textifier {
        /*
         * WARNING - void declaration
         */
        ChecksumPrinter(int api) {
            super((int)var1_1);
            void var1_1;
        }

        public void visitLineNumber(int line, Label start) {
        }

        protected Textifier createTextifier() {
            return new ChecksumPrinter(this.api);
        }
    }
}

