/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection.fix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.packageChecker.service.PackageService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0096\u0002R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/packageChecker/inspection/fix/ChangeVersionLocalQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "safeVersion", "", "pkg", "Lorg/jetbrains/security/package/Package;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lorg/jetbrains/security/package/Package;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getText", "invoke", "", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "intellij.packageChecker"})
public final class ChangeVersionLocalQuickFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String safeVersion;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Package pkg;

    public ChangeVersionLocalQuickFix(@NotNull PsiElement element, @NotNull String safeVersion, @NotNull Package pkg) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)safeVersion, (String)"safeVersion");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        super(element);
        this.safeVersion = safeVersion;
        this.pkg = pkg;
    }

    @NotNull
    public String getFamilyName() {
        String string = PackageCheckerBundle.message("change.version.quickfix.familyname", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.safeVersion};
        String string = PackageCheckerBundle.message("change.version.quickfix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PackageCheckerUsageStat.INSTANCE.getFixLocal().log(project);
        PackageService.Companion.getInstance(project).updateDependency(file2, this.pkg, this.safeVersion);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

